/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CdiBaseInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = CdiInspectionBundle.message("model.inspection.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiBaseInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cdi/highlighting/CdiBaseInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/cdi/highlighting/CdiBaseInspection", "checkFile"));
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            return null;
        }
        if (!CdiBaseInspection.isFileAccepted(file.getContainingFile())) {
            return null;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null || !CdiCommonUtils.isCdiInstalled(module)) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        this.checkJavaFile((PsiJavaFile)file, holder, isOnTheFly, module);
        List problemDescriptors = holder.getResults();
        if (problemDescriptors != null) {
            return problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
        }
        return null;
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull Module module) {
        if (javaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaFile", "com/intellij/cdi/highlighting/CdiBaseInspection", "checkJavaFile"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/cdi/highlighting/CdiBaseInspection", "checkJavaFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/highlighting/CdiBaseInspection", "checkJavaFile"));
        }
        for (PsiClass psiClass : javaFile.getClasses()) {
            this.checkClassInternal(psiClass, holder, module);
        }
    }

    private void checkClassInternal(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/highlighting/CdiBaseInspection", "checkClassInternal"));
        }
        this.checkClass(aClass, holder, module);
        for (PsiClass psiClass : aClass.getInnerClasses()) {
            this.checkClass(psiClass, holder, module);
        }
    }

    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/highlighting/CdiBaseInspection", "checkClass"));
        }
        if (CdiCommonUtils.isManagedBean(aClass)) {
            Set<CdiBeanDescriptor> descriptors = CdiManager.getService(module).resolveBeanByClass(aClass, new PsiAnnotation[0]);
            for (CdiBeanDescriptor descriptor : descriptors) {
                this.checkBeanDescriptor(descriptor, holder);
                if (!(descriptor instanceof ManagedBeanDescriptor)) continue;
                for (ProducerBeanDescriptor producerBeanDescriptor : ((ManagedBeanDescriptor)descriptor).getProducerDescriptors()) {
                    this.checkBeanDescriptor(producerBeanDescriptor, holder);
                }
            }
        }
    }

    protected void checkBeanDescriptor(CdiBeanDescriptor descriptor, ProblemsHolder holder) {
        if (descriptor instanceof ManagedBeanDescriptor) {
            this.checkManagedBean((ManagedBeanDescriptor)descriptor, holder);
        } else if (descriptor instanceof ProducerBeanDescriptor) {
            this.checkProducerBeanDescriptor((ProducerBeanDescriptor)descriptor, holder);
        }
    }

    protected void checkProducerBeanDescriptor(ProducerBeanDescriptor producerBeanDescriptor, ProblemsHolder holder) {
    }

    protected void checkManagedBean(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
    }

    protected static boolean isFileAccepted(PsiFile file) {
        if (!InspectionValidatorWrapper.isCompilationThread()) {
            return true;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        return module != null;
    }
}

