/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiAlternativeInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/highlighting/CdiAlternativeInspection", "checkClass"));
        }
        PsiAnnotation alternativeAnnotation = CdiAlternativeInspection.getAlternativeAnnotation(psiClass);
        if (alternativeAnnotation != null && CdiInjectionUtils.isVetoedClass(module, psiClass)) {
            holder.registerProblem((PsiElement)alternativeAnnotation, CdiInspectionBundle.message("alternative.bean.should.not.be.vetoed", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static PsiAnnotation getAlternativeAnnotation(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/highlighting/CdiAlternativeInspection", "getAlternativeAnnotation"));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"javax.enterprise.inject.Alternative"});
        if (annotation != null) {
            return annotation;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null) {
            return AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getAlternativeStereotypeAnnotationClasses(module)));
        }
        return null;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.alternative.errors", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiAlternativeInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiAlternativeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiAlternativeInspection", "getShortName"));
        }
        return "CdiAlternativeInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiAlternativeInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

