/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.diagram.edges;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.diagram.edges.CdiDependencyType;
import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.util.ui.PlatformColors;
import java.awt.Color;

public class CdiDiagramEdge
extends DiagramEdgeBase<CdiBeanDescriptor> {
    private CdiDependencyType myDependencyType;

    public CdiDiagramEdge(DiagramNode<CdiBeanDescriptor> source, DiagramNode<CdiBeanDescriptor> target, CdiDependencyType dependencyType, DiagramRelationshipInfo info) {
        super(source, target, info);
        this.myDependencyType = dependencyType;
    }

    public CdiDependencyType getDependencyType() {
        return this.myDependencyType;
    }

    protected static String getQualifierAnnotationsAsHtml(PsiAnnotation[] psiAnnotations) {
        if (psiAnnotations.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder("<html>");
        for (PsiAnnotation psiAnnotation : psiAnnotations) {
            String fqName = psiAnnotation.getQualifiedName();
            if (fqName == null) continue;
            buffer.append("@");
            buffer.append(StringUtil.getShortName((String)fqName));
            buffer.append("<br>");
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    public Color getAnchorColor() {
        return PlatformColors.BLUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CdiDiagramEdge)) {
            return false;
        }
        CdiDiagramEdge e = (CdiDiagramEdge)((Object)o);
        if (!e.getSource().equals(this.getSource()) || !e.getTarget().equals(this.getTarget())) {
            return false;
        }
        return this.myDependencyType == e.myDependencyType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myDependencyType != null ? this.myDependencyType.hashCode() : 0);
        return result;
    }
}

