/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.dependencies.renderers;

import com.intellij.cdi.dependencies.edges.CdiEdge;
import com.intellij.cdi.dependencies.nodes.CdiNode;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.builder.renderer.GradientFilledPanel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CdiNodeRenderer
extends AbstractColoredNodeCellRenderer {
    GraphBuilder<CdiNode, CdiEdge> myBuilder;

    public CdiNodeRenderer(@NotNull GraphBuilder<CdiNode, CdiEdge> builder, ModificationTracker modificationTracker) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/cdi/dependencies/renderers/CdiNodeRenderer", "<init>"));
        }
        super(modificationTracker);
        this.myBuilder = builder;
    }

    public void tuneNode(NodeRealizer realizer, JPanel wrapper) {
        wrapper.removeAll();
        Node node = realizer.getNode();
        CdiNode beansNode = (CdiNode)this.myBuilder.getNodeObject(node);
        if (beansNode != null) {
            Object element = beansNode.getIdentifyingElement();
            if (!element.isValid()) {
                return;
            }
            JLabel nameLabel = new JLabel(this.getNodeTitle(beansNode), beansNode.getIcon(), 0);
            nameLabel.setFont(nameLabel.getFont().deriveFont(1));
            nameLabel.setBorder(IdeBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
            nameLabel.setHorizontalAlignment(2);
            GradientFilledPanel namePanel = new GradientFilledPanel(DiagramColorManager.NODE_HEADER_COLOR);
            namePanel.setLayout((LayoutManager)new BorderLayout());
            namePanel.add((Component)nameLabel, (Object)"Center");
            namePanel.setBorder(BorderFactory.createLineBorder((Color)JBColor.WHITE, 1));
            nameLabel.setForeground(JBColor.foreground());
            wrapper.add((Component)namePanel, "North");
            JPanel propertiesPanel = new JPanel(new GridBagLayout());
            propertiesPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)5, (int)2, (int)5));
            propertiesPanel.setBackground(DiagramColorManager.NODE_BG_COLOR);
            wrapper.add((Component)propertiesPanel, "Center");
        }
    }

    protected String getNodeTitle(CdiNode pointer) {
        return this.myBuilder.getNodeName((Object)pointer);
    }

    protected int getSelectionBorderWidth() {
        return 2;
    }
}

