/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.dependencies.edges;

import com.intellij.cdi.dependencies.edges.CdiEdge;
import com.intellij.cdi.dependencies.edges.CdiEdgeType;
import com.intellij.cdi.dependencies.nodes.CdiNode;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;

public class CdiProducerEdge
implements CdiEdge {
    private final CdiNode mySource;
    private final CdiNode myTarget;
    private final PsiMember myPsiMember;

    public CdiProducerEdge(@NotNull CdiNode source, @NotNull CdiNode target, @NotNull PsiMember psiMember) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/cdi/dependencies/edges/CdiProducerEdge", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/cdi/dependencies/edges/CdiProducerEdge", "<init>"));
        }
        if (psiMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/cdi/dependencies/edges/CdiProducerEdge", "<init>"));
        }
        this.myPsiMember = psiMember;
        this.mySource = source;
        this.myTarget = target;
    }

    @Override
    public CdiNode getSource() {
        return this.mySource;
    }

    @Override
    public CdiNode getTarget() {
        return this.myTarget;
    }

    public PsiElement getIdentifyingElement() {
        return this.myPsiMember;
    }

    @Override
    public String getName() {
        PsiAnnotation[] qualifierAnnotations = CdiCommonUtils.getQualifierAnnotations((PsiModifierListOwner)this.myPsiMember);
        StringBuffer buffer = new StringBuffer();
        for (PsiAnnotation psiAnnotation : qualifierAnnotations) {
            String fqName = psiAnnotation.getQualifiedName();
            if (fqName == null) continue;
            buffer.append("@");
            buffer.append(StringUtil.getShortName((String)fqName));
            buffer.append(" ");
        }
        return buffer.toString();
    }

    @Override
    public CdiEdgeType getType() {
        return CdiEdgeType.PRODUCES;
    }

    @Override
    public boolean isValidDependency() {
        return true;
    }
}

