/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.dependencies.actions;

import com.intellij.cdi.dependencies.CdiDependenciesGraphComponent;
import com.intellij.cdi.dependencies.edges.CdiEdge;
import com.intellij.cdi.dependencies.nodes.CdiNode;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiTreeUtil;
import icons.CdiCoreIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowCdiDependenciesPopup
extends CodeInsightAction {
    public void update(AnActionEvent event) {
        super.update(event);
        event.getPresentation().setIcon(CdiCoreIcons.Cdi);
        event.getPresentation().setVisible(event.getPresentation().isEnabled());
        event.getPresentation().setText(CdiBundle.message("show.bean.dependencies.diagramm", new Object[0]));
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        CodeInsightActionHandler codeInsightActionHandler = new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cdi/dependencies/actions/ShowCdiDependenciesPopup$1", "invoke"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/cdi/dependencies/actions/ShowCdiDependenciesPopup$1", "invoke"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cdi/dependencies/actions/ShowCdiDependenciesPopup$1", "invoke"));
                }
                assert (file instanceof PsiJavaFile);
                ShowCdiDependenciesPopup.showDependenciesPopup(editor);
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
        if (codeInsightActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/dependencies/actions/ShowCdiDependenciesPopup", "getHandler"));
        }
        return codeInsightActionHandler;
    }

    private static void showDependenciesPopup(Editor editor) {
        CdiDependenciesGraphComponent graphComponent;
        PsiClass psiClass = ShowCdiDependenciesPopup.getTargetClass(editor);
        if (psiClass != null && (graphComponent = ShowCdiDependenciesPopup.createGraphComponent(psiClass)) != null) {
            JBPopup popup = ShowCdiDependenciesPopup.createPopup(graphComponent, CdiBundle.message("bean.dependencies.popup.title", psiClass.getName()));
            GraphBuilder<CdiNode, CdiEdge> builder = graphComponent.getBuilder();
            ShowCdiDependenciesPopup.setNodeSelection(psiClass, builder);
            GraphUtil.setBestPopupSizeForGraph((JBPopup)popup, builder);
            popup.showInBestPositionFor(editor);
            builder.getView().fitContent();
            ShowCdiDependenciesPopup.adjustScrollBar(builder);
            Disposer.register((Disposable)popup, builder);
        }
    }

    private static void setNodeSelection(PsiClass psiClass, GraphBuilder<CdiNode, CdiEdge> builder) {
        Graph2D graph = builder.getGraph();
        for (Node n : graph.getNodeArray()) {
            CdiNode nodeObject = (CdiNode)builder.getNodeObject(n);
            if (nodeObject == null) continue;
            boolean selected = psiClass.equals(nodeObject.getIdentifyingElement());
            graph.setSelected(n, selected);
        }
    }

    @Nullable
    private static PsiClass getTargetClass(Editor editor) {
        PsiElement element = TargetElementUtil.getInstance().findTargetElement(editor, 3, editor.getCaretModel().getOffset());
        if (element instanceof PsiClass) {
            return (PsiClass)element;
        }
        return element == null ? null : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
    }

    private static void adjustScrollBar(GraphBuilder<CdiNode, CdiEdge> builder) {
        Graph2DView graph2DView = (Graph2DView)builder.getGraph().getCurrentView();
        graph2DView.adjustScrollBarVisibility();
        graph2DView.adjustScrollBarVisibility();
    }

    @Nullable
    private static CdiDependenciesGraphComponent createGraphComponent(final PsiClass psiClass) {
        CdiDependenciesGraphComponent[] graphComponent = new CdiDependenciesGraphComponent[]{null};
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            graphComponent[0] = (CdiDependenciesGraphComponent)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CdiDependenciesGraphComponent>(){

                public CdiDependenciesGraphComponent compute() {
                    return new CdiDependenciesGraphComponent(psiClass);
                }
            });
        }, CdiBundle.message("generating.bean.dependencies.diagramm", new Object[0]), true, psiClass.getProject());
        return graphComponent[0];
    }

    private static JBPopup createPopup(final CdiDependenciesGraphComponent graphComponent, String title) {
        ComponentPopupBuilder popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)graphComponent, (JComponent)graphComponent);
        popupBuilder.setResizable(true).setFocusable(true).setMovable(true).setTitle(title).setTitleIcon(new ActiveIcon(CdiCoreIcons.Cdi, CdiCoreIcons.Cdi)).setCancelOnOtherWindowOpen(true).setAlpha(0.15f).setRequestFocus(true);
        popupBuilder.addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                Disposer.dispose((Disposable)graphComponent);
            }
        });
        return popupBuilder.createPopup();
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cdi/dependencies/actions/ShowCdiDependenciesPopup", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/cdi/dependencies/actions/ShowCdiDependenciesPopup", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cdi/dependencies/actions/ShowCdiDependenciesPopup", "isValidForFile"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null && file instanceof PsiJavaFile && CdiCommonUtils.isCdiInstalled(ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project)) && ShowCdiDependenciesPopup.getTargetClass(editor) != null;
    }
}

