/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCdiBeanDescriptor<T extends PsiMember>
implements CdiBeanDescriptor<T> {
    @NotNull
    public abstract T getAnnotatedItem();

    @Nullable
    protected abstract PsiClass getDefaultDeploymentType();

    @Override
    public Set<PsiClass> getQualifiers() {
        PsiClass defaultAnnotationClass;
        HashSet bindingTypes = new HashSet();
        Collection<String> qualifiedNames = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getQualifierClasses(this.getModule()));
        Object[] annotations = AnnotationUtil.findAnnotations(this.getAnnotatedItem(), qualifiedNames);
        if (annotations.length > 0) {
            bindingTypes.addAll(ContainerUtil.map2Set((Object[])annotations, psiAnnotation -> this.getAnnotationClass(psiAnnotation.getQualifiedName())));
        }
        if (!AnnotationUtil.isAnnotated(this.getAnnotatedItem(), (String)"javax.enterprise.inject.Specializes", (boolean)true) && (defaultAnnotationClass = this.getAnnotationClass("javax.enterprise.inject.Default")) != null) {
            bindingTypes.add(defaultAnnotationClass);
        }
        return bindingTypes;
    }

    @Override
    @Nullable
    public PsiClass getScopeType() {
        Module module = this.getModule();
        if (module != null) {
            Collection<String> qualifiedNames = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getNormalScopeTypesClasses(module));
            PsiAnnotation[] annotations = AnnotationUtil.findAnnotations(this.getAnnotatedItem(), qualifiedNames);
            if (annotations.length > 0) {
                return this.getAnnotationClass(annotations[0].getQualifiedName());
            }
        }
        return this.getAnnotationClass("javax.enterprise.context.Dependent");
    }

    @Override
    @Nullable
    public PsiClass getDeploymentType() {
        Module module = this.getModule();
        if (module != null) {
            Collection<String> qualifiedNames = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getDeploymentTypesClasses(module));
            PsiAnnotation[] annotations = AnnotationUtil.findAnnotations(this.getAnnotatedItem(), qualifiedNames);
            if (annotations.length > 0) {
                return this.getAnnotationClass(annotations[0].getQualifiedName());
            }
        }
        return this.getDefaultDeploymentType();
    }

    @Override
    @NotNull
    public Set<PsiClass> getStereotypes() {
        HashSet stereotypes = new HashSet();
        Module module = this.getModule();
        if (module != null) {
            Collection<PsiClass> stereotypeAnnotationClasses = CdiCommonUtils.getStereotypeAnnotationClasses(module);
            T annotatedItem = this.getAnnotatedItem();
            for (PsiClass psiClass : stereotypeAnnotationClasses) {
                if (!AnnotationUtil.isAnnotated(annotatedItem, (String)psiClass.getQualifiedName(), (boolean)true)) continue;
                stereotypes.add(psiClass);
            }
        }
        HashSet hashSet = stereotypes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/beans/AbstractCdiBeanDescriptor", "getStereotypes"));
        }
        return hashSet;
    }

    @Nullable
    protected PsiClass getAnnotationClass(@NotNull String annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/cdi/beans/AbstractCdiBeanDescriptor", "getAnnotationClass"));
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.getAnnotatedItem().getProject());
        Module module = this.getModule();
        GlobalSearchScope scope = module == null ? GlobalSearchScope.allScope((Project)this.getAnnotatedItem().getProject()) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        return psiFacade.findClass(annotation, scope);
    }

    @Nullable
    protected Module getModule() {
        return ModuleUtil.findModuleForPsiElement(this.getAnnotatedItem());
    }

    @Override
    public T getIdentifyingElement() {
        return this.getAnnotatedItem();
    }
}

