/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.actions;

import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiVersion;
import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.hash.HashMap;
import icons.CdiCoreIcons;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateBeansXmlAction
extends AnAction {
    public CreateBeansXmlAction() {
        super(CdiBundle.message("new.beans.xml.file.action.name", new Object[0]), CdiBundle.message("new.beans.xml.file.action.description", new Object[0]), CdiCoreIcons.Cdi);
    }

    public void actionPerformed(AnActionEvent e) {
        PsiDirectory[] directories = CreateBeansXmlAction.getSelectedDirectories(e.getDataContext());
        HashMap map = new HashMap();
        if (directories.length > 0) {
            FileTemplateManager manager = FileTemplateManager.getInstance((Project)directories[0].getProject());
            FileTemplate template = manager.getJ2eeTemplate(CreateBeansXmlAction.chooseTemplate(e.getDataContext()));
            try {
                FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)"beans.xml", (Map)map, (PsiDirectory)directories[0], null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String chooseTemplate(DataContext context) {
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        return CreateBeansXmlAction.chooseFileTemplate(module);
    }

    @NotNull
    public static String chooseFileTemplate(@Nullable Module module) {
        if (CdiCommonUtils.isCdiInstalled(module, CdiVersion.CDI_1_1)) {
            if ("cdi.beans_1_1.xml" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/actions/CreateBeansXmlAction", "chooseFileTemplate"));
            }
            return "cdi.beans_1_1.xml";
        }
        if ("cdi.beans_1_0.xml" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/actions/CreateBeansXmlAction", "chooseFileTemplate"));
        }
        return "cdi.beans_1_0.xml";
    }

    protected boolean isAvailable(DataContext dataContext) {
        PsiDirectory[] dirs;
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null || !CdiCommonUtils.isCdiInstalled(module)) {
            return false;
        }
        boolean isAvailable = false;
        for (PsiDirectory dir : dirs = CreateBeansXmlAction.getSelectedDirectories(dataContext)) {
            if (dir == null || !dir.getName().equals("WEB-INF") && !dir.getName().equals("META-INF")) continue;
            PsiFile file = dir.findFile("beans.xml");
            if (file == null) {
                isAvailable = true;
                continue;
            }
            return false;
        }
        return isAvailable;
    }

    @NotNull
    private static PsiDirectory[] getSelectedDirectories(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/cdi/actions/CreateBeansXmlAction", "getSelectedDirectories"));
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        PsiDirectory[] psiDirectoryArray = view != null ? view.getDirectories() : PsiDirectory.EMPTY_ARRAY;
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/actions/CreateBeansXmlAction", "getSelectedDirectories"));
        }
        return psiDirectoryArray;
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        boolean enabled = this.isAvailable(dataContext);
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }
}

