/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.javac.JavacFileManager;

public final class OutputFileObject
extends SimpleJavaFileObject {
    @Nullable
    private final JavacFileManager.Context myContext;
    @Nullable
    private final File myOutputRoot;
    private final String myRelativePath;
    private final File myFile;
    @Nullable
    private final String myClassName;
    @Nullable
    private final URI mySourceUri;
    private volatile BinaryContent myContent;
    private final File mySourceFile;
    private final String myEncodingName;

    public OutputFileObject(@NotNull JavacFileManager.Context context, @Nullable File outputRoot, String relativePath, @NotNull File file, @NotNull JavaFileObject.Kind kind, @Nullable String className, @Nullable URI sourceUri, @Nullable String encodingName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/javac/OutputFileObject", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/javac/OutputFileObject", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jps/javac/OutputFileObject", "<init>"));
        }
        this(context, outputRoot, relativePath, file, kind, className, sourceUri, encodingName, null);
    }

    public OutputFileObject(@Nullable JavacFileManager.Context context, @Nullable File outputRoot, String relativePath, @NotNull File file, @NotNull JavaFileObject.Kind kind, @Nullable String className, @Nullable URI srcUri, @Nullable String encodingName, @Nullable BinaryContent content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/javac/OutputFileObject", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jps/javac/OutputFileObject", "<init>"));
        }
        super(Utils.toURI(file.getPath()), kind);
        this.myContext = context;
        this.mySourceUri = srcUri;
        this.myContent = content;
        this.myOutputRoot = outputRoot;
        this.myRelativePath = relativePath;
        this.myFile = file;
        this.myClassName = className != null ? className.replace('/', '.') : null;
        this.mySourceFile = srcUri != null ? Utils.convertToFile(srcUri) : null;
        this.myEncodingName = encodingName;
    }

    @Nullable
    public File getOutputRoot() {
        return this.myOutputRoot;
    }

    public String getRelativePath() {
        return this.myRelativePath;
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/OutputFileObject", "getFile"));
        }
        return file;
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @Nullable
    public File getSourceFile() {
        return this.mySourceFile;
    }

    @Nullable
    public URI getSourceUri() {
        return this.mySourceUri;
    }

    @Override
    public ByteArrayOutputStream openOutputStream() {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    OutputFileObject.this.myContent = new BinaryContent(this.buf, 0, this.size());
                    if (OutputFileObject.this.myContext != null) {
                        OutputFileObject.this.myContext.consumeOutputFile(OutputFileObject.this);
                    }
                }
            }
        };
    }

    @Override
    public InputStream openInputStream() throws IOException {
        BinaryContent bytes = this.myContent;
        if (bytes != null) {
            return new ByteArrayInputStream(bytes.getBuffer(), bytes.getOffset(), bytes.getLength());
        }
        return new BufferedInputStream(new FileInputStream(this.myFile));
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        BinaryContent content = this.myContent;
        String encoding = this.myEncodingName;
        if (content != null) {
            return encoding == null ? new String(content.getBuffer(), content.getOffset(), content.getLength()) : new String(content.getBuffer(), content.getOffset(), content.getLength(), encoding);
        }
        return FileUtilRt.loadFile((File)this.myFile, (String)encoding, (boolean)false);
    }

    @Nullable
    public BinaryContent getContent() {
        return this.myContent;
    }

    public void updateContent(@NotNull byte[] updatedContent) {
        if (updatedContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedContent", "org/jetbrains/jps/javac/OutputFileObject", "updateContent"));
        }
        this.myContent = new BinaryContent(updatedContent, 0, updatedContent.length);
    }

    public int hashCode() {
        return this.toUri().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaFileObject && this.toUri().equals(((JavaFileObject)obj).toUri());
    }
}

