/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.instrumentation;

import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.compiler.notNullVerification.NotNullVerifyingInstrumenter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.instrumentation.BaseInstrumentingBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class NotNullInstrumentingBuilder
extends BaseInstrumentingBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.instrumentation.NotNullInstrumentingBuilder");

    @Override
    @NotNull
    public String getPresentableName() {
        if ("NotNull instrumentation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/instrumentation/NotNullInstrumentingBuilder", "getPresentableName"));
        }
        return "NotNull instrumentation";
    }

    @Override
    protected String getProgressMessage() {
        return "Adding @NotNull assertions...";
    }

    @Override
    protected boolean isEnabled(CompileContext context, ModuleChunk chunk) {
        ProjectDescriptor pd = context.getProjectDescriptor();
        return JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(pd.getProject()).isAddNotNullAssertions();
    }

    @Override
    protected boolean canInstrument(CompiledClass compiledClass, int classFileVersion) {
        return classFileVersion >= 49;
    }

    @Override
    @Nullable
    protected BinaryContent instrument(CompileContext context, CompiledClass compiledClass, ClassReader reader, ClassWriter writer, InstrumentationClassFinder finder) {
        try {
            ProjectDescriptor pd = context.getProjectDescriptor();
            List notNulls = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(pd.getProject()).getNotNullAnnotations();
            if (NotNullVerifyingInstrumenter.processClassFile((FailSafeClassReader)((FailSafeClassReader)reader), (ClassVisitor)writer, (String[])ArrayUtil.toStringArray((Collection)notNulls))) {
                return new BinaryContent(writer.toByteArray());
            }
        }
        catch (Throwable e) {
            LOG.error(e);
            Collection<File> sourceFiles = compiledClass.getSourceFiles();
            String msg = "Cannot instrument " + ContainerUtil.map(sourceFiles, (Function)new Function<File, String>(){

                public String fun(File file) {
                    return file.getName();
                }
            }) + ": " + e.getMessage();
            context.processMessage(new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, msg, (String)ContainerUtil.getFirstItem(compiledClass.getSourceFilesPaths())));
        }
        return null;
    }
}

