/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.ExternalDependencyId;

public class DefaultExternalDependencyId
implements ExternalDependencyId,
Serializable {
    private static final long serialVersionUID = 1L;
    private String group;
    private String name;
    private String version;
    @NotNull
    private String packaging = "jar";
    @Nullable
    private String classifier;

    public DefaultExternalDependencyId() {
    }

    public DefaultExternalDependencyId(String group, String name, String version) {
        this.group = group;
        this.name = name;
        this.version = version;
    }

    public DefaultExternalDependencyId(ExternalDependencyId dependencyId) {
        this(dependencyId.getGroup(), dependencyId.getName(), dependencyId.getVersion());
        this.packaging = dependencyId.getPackaging();
        this.classifier = dependencyId.getClassifier();
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    @NotNull
    public String getPackaging() {
        String string = this.packaging;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/DefaultExternalDependencyId", "getPackaging"));
        }
        return string;
    }

    public void setPackaging(@NotNull String packaging) {
        if (packaging == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packaging", "org/jetbrains/plugins/gradle/DefaultExternalDependencyId", "setPackaging"));
        }
        this.packaging = packaging;
    }

    @Override
    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(@Nullable String classifier) {
        this.classifier = classifier;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        StringBuilder buf = new StringBuilder();
        if (this.group != null) {
            buf.append(this.group).append(':');
        }
        if (this.name != null) {
            buf.append(this.name);
        }
        if (!"jar".equals(this.packaging)) {
            buf.append(':').append(this.packaging);
        }
        if (this.classifier != null) {
            buf.append(':').append(this.classifier);
        }
        if (this.version != null) {
            buf.append(':').append(this.version);
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/DefaultExternalDependencyId", "getPresentableName"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultExternalDependencyId)) {
            return false;
        }
        DefaultExternalDependencyId that = (DefaultExternalDependencyId)o;
        return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.packaging, (Object)that.packaging) && Objects.equal((Object)this.classifier, (Object)that.classifier) && Objects.equal((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.group, this.name, this.packaging, this.classifier, this.version});
    }

    public String toString() {
        return this.getPresentableName();
    }
}

