/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring.surround;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.coffeescript.CsBundle;
import org.coffeescript.refactoring.surround.CoffeeScriptWithTryCatchSurrounder;

public class CoffeeScriptWithTryFinallySurrounder
extends CoffeeScriptWithTryCatchSurrounder {
    @Override
    protected String getStatementTemplate(PsiElement context) {
        return "try\n  body\nfinally\n  finalization_code";
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSTryStatement tryStatement = (JSTryStatement)statementNode.getPsi();
        ASTNode errorNode = tryStatement.getFinallyStatement().getNode();
        int startOffset = errorNode.getStartOffset();
        int endOffset = startOffset + errorNode.getTextLength();
        return new TextRange(startOffset, endOffset);
    }

    @Override
    public String getTemplateDescription() {
        return CsBundle.message("surrounder.try.finally", new Object[0]);
    }
}

