/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import org.coffeescript.lang.lexer.CoffeeScriptFlexLexer;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptLiterateLexer
extends DelegateLexer {
    private int myTokenStart = 0;
    private boolean indented = false;
    private boolean newLine = false;
    public static final String LINE_BREAK_WITH_INDENT = "\n ";

    public CoffeeScriptLiterateLexer() {
        super((Lexer)new CoffeeScriptFlexLexer());
    }

    private void calculateTokenEnd() {
        if (this.myDelegate.getTokenType() == null) {
            this.indented = true;
            return;
        }
        String tokenText = this.myDelegate.getTokenText();
        if (this.newLine || this.getTokenStart() == 0) {
            this.indented = tokenText.startsWith(" ");
        }
        this.newLine = false;
        if (tokenText.endsWith("\n")) {
            this.newLine = true;
            return;
        }
        if (tokenText.contains(LINE_BREAK_WITH_INDENT)) {
            this.indented = true;
            return;
        }
        if (!this.indented) {
            LexerPosition previousPosition = null;
            while (this.myDelegate.getTokenEnd() < this.myDelegate.getBufferEnd() && this.myDelegate.getTokenType() != null && !tokenText.contains(LINE_BREAK_WITH_INDENT)) {
                previousPosition = this.myDelegate.getCurrentPosition();
                this.myDelegate.advance();
                tokenText = this.myDelegate.getTokenText();
            }
            if (tokenText.contains(LINE_BREAK_WITH_INDENT) && previousPosition != null) {
                this.myDelegate.restore(previousPosition);
            }
        }
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        LexerPosition lexerPosition = super.getCurrentPosition();
        if (lexerPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/lexer/CoffeeScriptLiterateLexer", "getCurrentPosition"));
        }
        return lexerPosition;
    }

    public void advance() {
        this.myDelegate.advance();
        this.myTokenStart = this.myDelegate.getTokenStart();
        this.calculateTokenEnd();
    }

    @Nullable
    public IElementType getTokenType() {
        if (!this.indented) {
            return CoffeeScriptTokenTypes.BLOCK_COMMENT;
        }
        return this.myDelegate.getTokenType();
    }

    @NotNull
    public CharSequence getTokenSequence() {
        CharSequence charSequence = super.getTokenSequence();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/lang/lexer/CoffeeScriptLiterateLexer", "getTokenSequence"));
        }
        return charSequence;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/coffeescript/lang/lexer/CoffeeScriptLiterateLexer", "start"));
        }
        this.newLine = false;
        this.indented = false;
        super.start(buffer, startOffset, endOffset, initialState);
        this.myTokenStart = this.myDelegate.getTokenStart();
        if (this.myTokenStart > 0) {
            int i;
            for (i = this.myTokenStart; i >= 0 && buffer.charAt(i) != '\n'; --i) {
            }
            this.indented = i < 0 ? buffer.charAt(0) == ' ' : buffer.charAt(i + 1) == ' ';
        }
        this.calculateTokenEnd();
    }

    public int getTokenStart() {
        return this.myTokenStart;
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/coffeescript/lang/lexer/CoffeeScriptLiterateLexer", "restore"));
        }
        super.restore(position);
        this.myTokenStart = this.myDelegate.getTokenStart();
        this.calculateTokenEnd();
    }
}

