/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.highlighter;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSCheckFunctionSignaturesInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.coffeescript.CoffeeScriptUtil;
import org.coffeescript.CsBundle;
import org.coffeescript.codeinsight.inspections.CoffeeScriptArgumentsOutsideFunctionInspection;
import org.coffeescript.highlighter.CoffeeScriptSyntaxHighlighter;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptAnnotatingVisitor
extends JSAnnotatingVisitor {
    final List<IElementType> OPERATOR_KEYWORDS;

    public CoffeeScriptAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor", "<init>"));
        }
        super(psiElement, holder);
        this.OPERATOR_KEYWORDS = Arrays.asList(JSTokenTypes.ANDAND, JSTokenTypes.OROR, JSTokenTypes.EXCL, CoffeeScriptTokenTypes.EQ_EQ_EQ, CoffeeScriptTokenTypes.NOT_EQ_EQ);
    }

    @NotNull
    protected JSFunctionSignatureChecker createFunctionSignatureChecker(PsiElement context) {
        CoffeeScriptFunctionSignatureChecker coffeeScriptFunctionSignatureChecker = new CoffeeScriptFunctionSignatureChecker(this.myTypeChecker);
        if (coffeeScriptFunctionSignatureChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor", "createFunctionSignatureChecker"));
        }
        return coffeeScriptFunctionSignatureChecker;
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        PsiElement operator;
        if (node instanceof JSBinaryExpressionImpl && (operator = ((JSBinaryExpressionImpl)node).getOperator()) != null && this.OPERATOR_KEYWORDS.contains(operator.getNode().getElementType()) && StringUtil.containsAlphaCharacters((String)operator.getText())) {
            this.myHolder.createInfoAnnotation(operator, null).setTextAttributes(CoffeeScriptSyntaxHighlighter.KEYWORD);
        }
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        if (this.OPERATOR_KEYWORDS.contains(node.getOperationSign())) {
            this.myHolder.createInfoAnnotation(node.getFirstChild(), null).setTextAttributes(CoffeeScriptSyntaxHighlighter.KEYWORD);
        }
    }

    protected boolean needsInitializer(JSParameterListElement parameter) {
        return false;
    }

    protected Annotation reportUnresolvedRefProblem(ProblemHighlightType unresolveReferenceHighlightType, List<LocalQuickFix> quickFixes, @NotNull PsiElement referenceNameElement, @NotNull String message, String inspectionId) {
        if (referenceNameElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceNameElement", "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor", "reportUnresolvedRefProblem"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor", "reportUnresolvedRefProblem"));
        }
        return super.reportUnresolvedRefProblem(unresolveReferenceHighlightType, Collections.emptyList(), referenceNameElement, message, inspectionId);
    }

    protected void checkCallReferences(JSCallExpression node, JSReferenceExpression referenceExpression) {
        ResolveResult[] resolveResults = referenceExpression.multiResolve(false);
        if (resolveResults.length != 1 || !(resolveResults[0].getElement() instanceof JSVariable) || referenceExpression.getQualifier() != null) {
            super.checkCallReferences(node, referenceExpression);
        }
    }

    public void visitJSParameter(JSParameter node) {
        JSFunction function;
        super.visitJSParameter(node);
        if (node.getText().startsWith("@") && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunctionExpression.class)) != null && CoffeeScriptUtil.canHoldImplicitProperties(function)) {
            this.myHolder.createInfoAnnotation(node.getLastChild(), null).setTextAttributes(CoffeeScriptSyntaxHighlighter.GLOBAL_VARIABLE);
        }
    }

    public void visitJSReturnStatement(JSReturnStatement node) {
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        if (!CoffeeScriptArgumentsOutsideFunctionInspection.argumentsOutsideFunction(node)) {
            super.visitJSReferenceExpression(node);
        }
    }

    private class CoffeeScriptFunctionSignatureChecker
    extends JSFunctionSignatureChecker {
        public CoffeeScriptFunctionSignatureChecker(JSTypeChecker typeChecker) {
            super(typeChecker);
        }

        protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
            PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem((JSCallExpression)callExpression, (JSArgumentList)callExpression.getArgumentList());
            CoffeeScriptAnnotatingVisitor.this.myProblemReporter.registerProblem(place, message, null, JSCheckFunctionSignaturesInspection.SHORT_NAME, fixes);
        }

        public void checkFunction(@NotNull JSCallExpression node, @NotNull PsiElement element) {
            JSClass clazz;
            JSFunction constructor;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor$CoffeeScriptFunctionSignatureChecker", "checkFunction"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor$CoffeeScriptFunctionSignatureChecker", "checkFunction"));
            }
            if (element instanceof JSClass && (constructor = (clazz = (JSClass)element).getConstructor()) != null) {
                int mandatoryParameters = constructor.getParameterVariables().length;
                for (JSParameter parameter : constructor.getParameterVariables()) {
                    if (!parameter.isOptional()) continue;
                    --mandatoryParameters;
                }
                this.reportProblemIfNotExpectedCountOfParameters(node, mandatoryParameters, constructor.getParameters().length);
            }
        }

        public void reportProblemIfNotExpectedCountOfParameters(JSCallExpression node, int minCount, int maxCount) {
            JSExpression[] arguments = node.getArguments();
            if (arguments.length < minCount || arguments.length > maxCount) {
                if (minCount == maxCount) {
                    this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{minCount}), new LocalQuickFix[0]);
                } else {
                    this.registerProblem(node, CsBundle.message("inspection.invalid.number.of.parameters.range", minCount, maxCount), new LocalQuickFix[0]);
                }
            }
        }

        protected void checkCallParameters(@NotNull JSCallExpression call, @Nullable PsiElement element) {
            JSArgumentList argumentList;
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor$CoffeeScriptFunctionSignatureChecker", "checkCallParameters"));
            }
            if (element instanceof JSFunction) {
                for (JSParameter parameter : ((JSFunction)element).getParameterVariables()) {
                    if (parameter.getNode().findChildByType(CoffeeScriptTokenTypes.SPLAT) == null) continue;
                    return;
                }
            }
            if ((argumentList = call.getArgumentList()) != null && argumentList.getNode().findChildByType(CoffeeScriptTokenTypes.SPLAT) != null) {
                return;
            }
            super.checkCallParameters(call, element);
        }
    }
}

