/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.formatter;

import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import javax.swing.JCheckBox;
import org.coffeescript.formatter.CoffeeScriptCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptIndentOptionsEditor
extends SmartIndentOptionsEditor {
    private JCheckBox myIndentOptionsCheckBox;

    protected void addComponents() {
        super.addComponents();
        this.myIndentOptionsCheckBox = new JCheckBox("Indent chained methods");
        this.add(this.myIndentOptionsCheckBox);
    }

    public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        super.apply(settings, options);
        CoffeeScriptCodeStyleSettings coffeeScriptSettings = (CoffeeScriptCodeStyleSettings)settings.getCustomSettings(CoffeeScriptCodeStyleSettings.class);
        coffeeScriptSettings.INDENT_CHAINED_CALLS = this.myIndentOptionsCheckBox.isSelected();
    }

    public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        CoffeeScriptCodeStyleSettings coffeeScriptSettings = (CoffeeScriptCodeStyleSettings)settings.getCustomSettings(CoffeeScriptCodeStyleSettings.class);
        return super.isModified(settings, options) || this.myIndentOptionsCheckBox.isSelected() != coffeeScriptSettings.INDENT_CHAINED_CALLS;
    }

    public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/coffeescript/formatter/CoffeeScriptIndentOptionsEditor", "reset"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/coffeescript/formatter/CoffeeScriptIndentOptionsEditor", "reset"));
        }
        super.reset(settings, options);
        CoffeeScriptCodeStyleSettings coffeeScriptSettings = (CoffeeScriptCodeStyleSettings)settings.getCustomSettings(CoffeeScriptCodeStyleSettings.class);
        this.myIndentOptionsCheckBox.setSelected(coffeeScriptSettings.INDENT_CHAINED_CALLS);
    }
}

