/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.compiler;

import com.google.common.io.CharStreams;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.coffeescript.lang.psi.CoffeeScriptFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class CoffeeScriptCompiler {
    private static final Logger LOG = Logger.getInstance((String)CoffeeScriptCompiler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String readFileFromJar(@NotNull String resourceName) {
        String string;
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "org/coffeescript/compiler/CoffeeScriptCompiler", "readFileFromJar"));
        }
        ClassLoader classLoader = CoffeeScriptCompiler.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(resourceName);
        InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
        try {
            string = CharStreams.toString((Readable)reader);
        }
        catch (Throwable throwable) {
            try {
                ((Reader)reader).close();
                throw throwable;
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        ((Reader)reader).close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compile(@NotNull String textToCompile) throws IOException {
        if (textToCompile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textToCompile", "org/coffeescript/compiler/CoffeeScriptCompiler", "compile"));
        }
        String coffeeScriptJS = CoffeeScriptCompiler.readFileFromJar("coffee-script.js");
        Context context = Context.enter();
        try {
            context.setOptimizationLevel(-1);
            ScriptableObject scope = context.initStandardObjects();
            context.evaluateString((Scriptable)scope, coffeeScriptJS, "original CoffeeScript compiler", 0, null);
            scope.put("coffeeScriptSource", (Scriptable)scope, (Object)textToCompile);
            String string = (String)context.evaluateString((Scriptable)scope, "CoffeeScript.compile(coffeeScriptSource);", "CoffeeScript compiler for JetBrains", 0, null);
            return string;
        }
        catch (JavaScriptException ex) {
            ScriptableObject nativeError;
            Object locationObject;
            String exceptionLocation = "";
            Object value = ex.getValue();
            if (value instanceof ScriptableObject && (locationObject = (nativeError = (ScriptableObject)value).get((Object)"location")) instanceof ScriptableObject) {
                Object first_column;
                ScriptableObject location = (ScriptableObject)locationObject;
                Object first_line = location.get((Object)"first_line");
                if (first_line instanceof Number) {
                    exceptionLocation = exceptionLocation + "\nLine: " + (((Number)first_line).intValue() + 1);
                }
                if ((first_column = location.get((Object)"first_column")) instanceof Number) {
                    exceptionLocation = exceptionLocation + "\nColumn: " + (((Number)first_column).intValue() + 1);
                }
            }
            String string = "Exception raised during CoffeeScript compilation:\n" + ex.details() + exceptionLocation;
            return string;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sourceMap(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/coffeescript/compiler/CoffeeScriptCompiler", "sourceMap"));
        }
        PsiDirectory parentDirectory = file.getParent();
        assert (parentDirectory != null);
        String coffeeScriptReduxJS = CoffeeScriptCompiler.readFileFromJar("coffee-script-redux.js");
        Context context = Context.enter();
        String sourceMap = null;
        try {
            context.setOptimizationLevel(-1);
            ScriptableObject scope = context.initStandardObjects();
            context.evaluateString((Scriptable)scope, "var root = new Object();", "root", 0, null);
            context.evaluateString((Scriptable)scope, coffeeScriptReduxJS, "coffee-script-redux.js", 0, null);
            scope.put("coffeeScriptSource", (Scriptable)scope, (Object)file.getText());
            sourceMap = (String)context.evaluateString((Scriptable)scope, "root.CoffeeScript.sourceMap(root.CoffeeScript.compile(root.CoffeeScript.parse.apply(root, [coffeeScriptSource])))", "test", 0, null);
        }
        catch (JavaScriptException jse) {
            LOG.info(String.format("Can't generate source maps for: %s", file.getName()));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            Context.exit();
        }
        if (sourceMap != null) {
            String suffixToReplace = file.getName().endsWith(".js.coffee") ? ".js.coffee" : (file.getName().endsWith(".coffee") ? ".coffee" : "");
            String sourceMapFileName = file.getName().substring(0, file.getName().length() - suffixToReplace.length()) + ".js.map";
            String finalSourceMap = sourceMap.replaceAll("unknown", file.getName());
            ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                OutputStreamWriter fw = null;
                try {
                    fw = new FileWriter(parentDirectory.getVirtualFile().getPath() + "/" + sourceMapFileName);
                    fw.write(finalSourceMap);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (fw != null) {
                        try {
                            fw.flush();
                            fw.close();
                        }
                        catch (IOException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }));
        }
    }

    public static void compileDirectory(@NotNull PsiDirectory directory, @Nullable ProgressIndicator indicator) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/coffeescript/compiler/CoffeeScriptCompiler", "compileDirectory"));
        }
        Ref filesRef = new Ref();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/coffeescript/compiler/CoffeeScriptCompiler", "lambda$compileDirectory$2"));
            }
            filesRef.set((Object)directory.getFiles());
        });
        for (PsiFile file : (PsiFile[])filesRef.get()) {
            if (indicator != null && indicator.isCanceled()) break;
            if (file instanceof PsiDirectory) {
                CoffeeScriptCompiler.compileDirectory((PsiDirectory)file, indicator);
                continue;
            }
            if (!(file instanceof CoffeeScriptFile)) continue;
            if (indicator != null) {
                indicator.setText("Source maps for: " + file.getName());
            }
            CoffeeScriptCompiler.sourceMap(file);
        }
    }
}

