/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.coffeescript.lang.parser.CoffeeScriptElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptDocStringUtil {
    public static final String DOC_STRING_LITERAL = "\"\"\"";
    public static final String DOC_STRING_LITERAL2 = "'''";

    public static String getDocStringValue(@NotNull String elementText, @Nullable List<TextRange> ranges) {
        if (elementText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementText", "org/coffeescript/CoffeeScriptDocStringUtil", "getDocStringValue"));
        }
        if (ranges == null) {
            ranges = new ArrayList<TextRange>();
        }
        String text = elementText.substring(DOC_STRING_LITERAL.length(), elementText.length() - DOC_STRING_LITERAL.length());
        String[] lines = text.split("\n");
        int spaceLineCount = 0;
        int minSpace = Integer.MAX_VALUE;
        int spaceLineIndex = -1;
        for (int i = 1; i < lines.length; ++i) {
            int j;
            String s = lines[i];
            for (j = 0; j < s.length() && s.charAt(j) == ' '; ++j) {
            }
            if (j == 0 && s.length() > 0) {
                minSpace = 0;
                continue;
            }
            if (j <= 0) continue;
            ++spaceLineCount;
            if (minSpace <= j) continue;
            minSpace = j;
            spaceLineIndex = i;
        }
        if (minSpace == Integer.MAX_VALUE) {
            minSpace = 0;
        }
        int offset = 4;
        StringBuilder result = new StringBuilder();
        if (lines.length > 0 && lines[0].length() > 0) {
            result.append(lines[0]).append("\n");
            int lineBreak = lines.length > 1 ? 1 : 0;
            ranges.add(new TextRange(--offset, offset + lines[0].length() + lineBreak));
            offset += lines[0].length();
            if (lines.length > 1) {
                ++offset;
            }
        }
        boolean firstNonEmptyLine = true;
        for (int i = 1; i < lines.length; ++i) {
            int lineBreak = i < lines.length - 1 ? 1 : 0;
            String s = lines[i];
            if (s.length() > 0) {
                String toAdd;
                if (firstNonEmptyLine && i == spaceLineIndex) {
                    toAdd = s.trim();
                    int spaceCount = s.length() - toAdd.length();
                    result.append(toAdd);
                    ranges.add(new TextRange(spaceCount + offset, spaceCount + offset + toAdd.length() + lineBreak));
                } else if (spaceLineCount != 1) {
                    toAdd = s.substring(minSpace);
                    result.append(toAdd);
                    ranges.add(new TextRange(minSpace + offset, minSpace + offset + toAdd.length() + lineBreak));
                } else {
                    result.append(s);
                    ranges.add(new TextRange(minSpace + offset, minSpace + offset + s.length() + lineBreak));
                }
                firstNonEmptyLine = false;
            } else {
                ranges.add(new TextRange(offset, offset + s.length() + lineBreak));
            }
            result.append('\n');
            offset += s.length() + 1;
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static List<TextRange> getDocStringValue(@NotNull String elementText) {
        if (elementText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementText", "org/coffeescript/CoffeeScriptDocStringUtil", "getDocStringValue"));
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        CoffeeScriptDocStringUtil.getDocStringValue(elementText, result);
        return result;
    }

    public static String getDocStringElementText(@NotNull String value, int offset) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/coffeescript/CoffeeScriptDocStringUtil", "getDocStringElementText"));
        }
        String[] lines = value.split("\n");
        String prefix = StringUtil.repeat((String)" ", (int)offset);
        StringBuilder result = new StringBuilder("\"\"\"\n");
        for (String s : lines) {
            result.append(prefix).append(s).append('\n');
        }
        result.append(DOC_STRING_LITERAL);
        return result.toString();
    }

    public static boolean isDocString(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/coffeescript/CoffeeScriptDocStringUtil", "isDocString"));
        }
        return node.getElementType() == CoffeeScriptElementTypes.LITERAL_EXPRESSION && (node.getText().startsWith(DOC_STRING_LITERAL) || node.getText().startsWith(DOC_STRING_LITERAL2));
    }
}

