/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.model.xml.converters;

import com.intellij.jboss.jpdl.model.JpdlDomModelManager;
import com.intellij.jboss.jpdl.model.JpdlModel;
import com.intellij.jboss.jpdl.model.xml.JpdlNamedActivity;
import com.intellij.jboss.jpdl.model.xml.ProcessDefinition;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpdlTransitionTargetConverter
extends ResolvingConverter<JpdlNamedActivity> {
    @NotNull
    public Collection<? extends JpdlNamedActivity> getVariants(ConvertContext context) {
        List<JpdlNamedActivity> list = JpdlTransitionTargetConverter.getAllNamedActivities(JpdlTransitionTargetConverter.getProcessDefinition(context));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/model/xml/converters/JpdlTransitionTargetConverter", "getVariants"));
        }
        return list;
    }

    public PsiElement getPsiElement(@Nullable JpdlNamedActivity resolvedValue) {
        return PomService.convertToPsi((PsiTarget)DomTarget.getTarget((DomElement)resolvedValue));
    }

    public JpdlNamedActivity fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        ProcessDefinition processDefinition = JpdlTransitionTargetConverter.getProcessDefinition(context);
        for (JpdlNamedActivity namedElement : JpdlTransitionTargetConverter.getAllNamedActivities(processDefinition)) {
            if (!s.equals(namedElement.getName().getStringValue())) continue;
            return namedElement;
        }
        return null;
    }

    @Nullable
    private static ProcessDefinition getProcessDefinition(ConvertContext context) {
        JpdlModel model = JpdlDomModelManager.getInstance(context.getFile().getProject()).getJpdlModel(context.getFile());
        if (model == null || model.getRoots().size() != 1) {
            return null;
        }
        return (ProcessDefinition)((DomFileElement)model.getRoots().get(0)).getRootElement();
    }

    private static List<JpdlNamedActivity> getAllNamedActivities(@Nullable ProcessDefinition processDefinition) {
        ArrayList<JpdlNamedActivity> elements = new ArrayList<JpdlNamedActivity>();
        if (processDefinition != null) {
            elements.addAll(processDefinition.getCustoms());
            elements.addAll(processDefinition.getDecisions());
            elements.addAll(processDefinition.getEnds());
            elements.addAll(processDefinition.getEndCancels());
            elements.addAll(processDefinition.getEndErrors());
            elements.addAll(processDefinition.getForks());
            elements.addAll(processDefinition.getGroups());
            elements.addAll(processDefinition.getHqls());
            elements.addAll(processDefinition.getSqls());
            elements.addAll(processDefinition.getJavas());
            elements.addAll(processDefinition.getJmses());
            elements.addAll(processDefinition.getJoins());
            elements.addAll(processDefinition.getMails());
            elements.addAll(processDefinition.getRules());
            elements.addAll(processDefinition.getRulesDecisions());
            elements.addAll(processDefinition.getScripts());
            elements.addAll(processDefinition.getSqls());
            elements.addAll(processDefinition.getStarts());
            elements.addAll(processDefinition.getStates());
            elements.addAll(processDefinition.getSubProcesses());
            elements.addAll(processDefinition.getTasks());
            elements.addAll(processDefinition.getCustoms());
        }
        return elements;
    }

    public String toString(@Nullable JpdlNamedActivity namedActivity, ConvertContext context) {
        return namedActivity == null ? null : namedActivity.getName().getStringValue();
    }
}

