/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.model.xml.converters;

import com.intellij.jboss.jpdl.model.xml.wireObjectGroup.JavaActivity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaActivityMethodConverter
extends ResolvingConverter<PsiMethod> {
    @NotNull
    public Collection<? extends PsiMethod> getVariants(ConvertContext context) {
        Collection<? extends PsiMethod> collection = JavaActivityMethodConverter.getAllMethods(context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/model/xml/converters/JavaActivityMethodConverter", "getVariants"));
        }
        return collection;
    }

    private static Collection<? extends PsiMethod> getAllMethods(ConvertContext context) {
        PsiClass psiClass;
        JavaActivity javaActivity = (JavaActivity)context.getInvocationElement().getParentOfType(JavaActivity.class, false);
        HashSet<PsiMethod> methods = new HashSet<PsiMethod>();
        if (javaActivity != null && (psiClass = JavaActivityMethodConverter.getPsiClass(javaActivity)) != null) {
            methods.addAll(Arrays.asList(psiClass.getAllMethods()));
        }
        return methods;
    }

    private static PsiClass getPsiClass(JavaActivity javaActivity) {
        return (PsiClass)javaActivity.getClazz().getValue();
    }

    public PsiMethod fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s != null) {
            for (PsiMethod psiMethod : JavaActivityMethodConverter.getAllMethods(context)) {
                if (!s.equals(psiMethod.getName())) continue;
                return psiMethod;
            }
        }
        return null;
    }

    public String toString(@Nullable PsiMethod psiMethod, ConvertContext context) {
        return psiMethod != null ? psiMethod.getName() : null;
    }
}

