/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.model;

import com.intellij.jboss.jpdl.impl.JpdlModelImpl;
import com.intellij.jboss.jpdl.model.JpdlModel;
import com.intellij.jboss.jpdl.model.xml.ProcessDefinition;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.model.impl.DomModelFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpdlModelFactory
extends DomModelFactory<ProcessDefinition, JpdlModel, PsiElement> {
    public JpdlModelFactory(Project project) {
        super(ProcessDefinition.class, project, "process");
    }

    protected List<JpdlModel> computeAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jboss/jpdl/model/JpdlModelFactory", "computeAllModels"));
        }
        ArrayList<JpdlModel> models = new ArrayList<JpdlModel>();
        GlobalSearchScope moduleContentScope = module.getModuleContentScope();
        Collection jpdlCandidateFiles = DomService.getInstance().getDomFileCandidates(ProcessDefinition.class, module.getProject(), moduleContentScope);
        for (VirtualFile jpdlCandidateFile : jpdlCandidateFiles) {
            JpdlModel jpdlModel;
            PsiFile file = PsiManager.getInstance((Project)module.getProject()).findFile(jpdlCandidateFile);
            if (!(file instanceof XmlFile) || (jpdlModel = this.computeModel((XmlFile)file, module)) == null) continue;
            models.add(jpdlModel);
        }
        return models;
    }

    @Nullable
    public JpdlModel getModelByConfigFile(@Nullable XmlFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        return this.computeModel(psiFile, ModuleUtil.findModuleForPsiElement((PsiElement)psiFile));
    }

    protected JpdlModel computeModel(@NotNull XmlFile psiFile, @Nullable Module module) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/jboss/jpdl/model/JpdlModelFactory", "computeModel"));
        }
        if (module == null) {
            return null;
        }
        return this.createSingleModel(psiFile, module);
    }

    @Nullable
    private JpdlModel createSingleModel(XmlFile psiFile, Module module) {
        DomFileElement componentsDomFileElement = this.getDomRoot(psiFile);
        if (componentsDomFileElement != null) {
            DomFileElement fileElement;
            HashSet<XmlFile> files = new HashSet<XmlFile>();
            files.add(psiFile);
            DomFileElement domFileElement = fileElement = files.size() > 1 ? this.createMergedModelRoot(files) : componentsDomFileElement;
            if (fileElement != null) {
                return new JpdlModelImpl(module, (DomFileElement<ProcessDefinition>)fileElement, files);
            }
        }
        return null;
    }

    protected JpdlModel createCombinedModel(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<ProcessDefinition> mergedModel, JpdlModel firstModel, Module module) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFiles", "com/intellij/jboss/jpdl/model/JpdlModelFactory", "createCombinedModel"));
        }
        if (mergedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedModel", "com/intellij/jboss/jpdl/model/JpdlModelFactory", "createCombinedModel"));
        }
        throw new UnsupportedOperationException();
    }
}

