/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.graph.nodes;

import com.intellij.jboss.jpdl.graph.JpdlEdge;
import com.intellij.jboss.jpdl.graph.JpdlNode;
import com.intellij.jboss.jpdl.model.xml.Transition;
import org.jetbrains.annotations.NotNull;

public class JpdlBasicEdge
implements JpdlEdge {
    private final JpdlNode mySource;
    private final JpdlNode myTarget;
    private final String myName;
    private final Transition myTransition;
    private final boolean myDuplicated;

    @Override
    public JpdlNode getSource() {
        return this.mySource;
    }

    public JpdlBasicEdge(JpdlNode source, JpdlNode target, Transition transition, boolean duplicated) {
        this.mySource = source;
        this.myTarget = target;
        this.myName = transition.getName().getStringValue();
        this.myTransition = transition;
        this.myDuplicated = duplicated;
    }

    @Override
    public JpdlNode getTarget() {
        return this.myTarget;
    }

    @Override
    public String getName() {
        return this.myName == null ? "" : this.myName;
    }

    @Override
    @NotNull
    public Transition getIdentifyingElement() {
        Transition transition = this.myTransition;
        if (transition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/graph/nodes/JpdlBasicEdge", "getIdentifyingElement"));
        }
        return transition;
    }

    @Override
    public boolean isDuplicated() {
        return this.myDuplicated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpdlBasicEdge that = (JpdlBasicEdge)o;
        if (this.mySource != null ? !this.mySource.equals(that.mySource) : that.mySource != null) {
            return false;
        }
        if (this.myTarget != null ? !this.myTarget.equals(that.myTarget) : that.myTarget != null) {
            return false;
        }
        return !(this.myTransition != null ? !this.myTransition.equals(that.myTransition) : that.myTransition != null);
    }

    public int hashCode() {
        int result = this.mySource != null ? this.mySource.hashCode() : 0;
        result = 31 * result + (this.myTarget != null ? this.myTarget.hashCode() : 0);
        result = 31 * result + (this.myTransition != null ? this.myTransition.hashCode() : 0);
        return result;
    }
}

