/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.graph;

import com.intellij.jboss.jpdl.graph.JpdlEdge;
import com.intellij.jboss.jpdl.graph.JpdlNode;
import com.intellij.jboss.jpdl.graph.nodes.CustomNode;
import com.intellij.jboss.jpdl.graph.nodes.DecisionNode;
import com.intellij.jboss.jpdl.graph.nodes.EndActivityNode;
import com.intellij.jboss.jpdl.graph.nodes.ForkNode;
import com.intellij.jboss.jpdl.graph.nodes.GroupNode;
import com.intellij.jboss.jpdl.graph.nodes.HqlNode;
import com.intellij.jboss.jpdl.graph.nodes.JavaNode;
import com.intellij.jboss.jpdl.graph.nodes.JoinNode;
import com.intellij.jboss.jpdl.graph.nodes.JpdlBasicEdge;
import com.intellij.jboss.jpdl.graph.nodes.MailNode;
import com.intellij.jboss.jpdl.graph.nodes.RulesDecisionNode;
import com.intellij.jboss.jpdl.graph.nodes.RulesNode;
import com.intellij.jboss.jpdl.graph.nodes.ScriptNode;
import com.intellij.jboss.jpdl.graph.nodes.SqlNode;
import com.intellij.jboss.jpdl.graph.nodes.StartNode;
import com.intellij.jboss.jpdl.graph.nodes.StateNode;
import com.intellij.jboss.jpdl.graph.nodes.SubProcessNode;
import com.intellij.jboss.jpdl.graph.nodes.TaskNode;
import com.intellij.jboss.jpdl.model.JpdlDomModelManager;
import com.intellij.jboss.jpdl.model.JpdlModel;
import com.intellij.jboss.jpdl.model.xml.Custom;
import com.intellij.jboss.jpdl.model.xml.Decision;
import com.intellij.jboss.jpdl.model.xml.End;
import com.intellij.jboss.jpdl.model.xml.EndCancel;
import com.intellij.jboss.jpdl.model.xml.EndError;
import com.intellij.jboss.jpdl.model.xml.Fork;
import com.intellij.jboss.jpdl.model.xml.Group;
import com.intellij.jboss.jpdl.model.xml.Hql;
import com.intellij.jboss.jpdl.model.xml.Join;
import com.intellij.jboss.jpdl.model.xml.JpdlNamedActivity;
import com.intellij.jboss.jpdl.model.xml.Mail;
import com.intellij.jboss.jpdl.model.xml.ProcessDefinition;
import com.intellij.jboss.jpdl.model.xml.Rules;
import com.intellij.jboss.jpdl.model.xml.RulesDecision;
import com.intellij.jboss.jpdl.model.xml.Script;
import com.intellij.jboss.jpdl.model.xml.Sql;
import com.intellij.jboss.jpdl.model.xml.Start;
import com.intellij.jboss.jpdl.model.xml.State;
import com.intellij.jboss.jpdl.model.xml.SubProcess;
import com.intellij.jboss.jpdl.model.xml.Task;
import com.intellij.jboss.jpdl.model.xml.Transition;
import com.intellij.jboss.jpdl.model.xml.TransitionOwner;
import com.intellij.jboss.jpdl.model.xml.wireObjectGroup.JavaActivity;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpdlDataModel
extends GraphDataModel<JpdlNode, JpdlEdge> {
    private final Collection<JpdlNode> myNodes = new HashSet();
    private final Collection<JpdlEdge> myEdges = new HashSet();
    protected final Map<PsiFile, NodesGroup> myGroups = new HashMap<PsiFile, NodesGroup>();
    private final Project myProject;
    private final XmlFile myFile;
    @NonNls
    private static final String UNDEFINED_NAME = "Undefined";

    public JpdlDataModel(XmlFile file) {
        this.myFile = file;
        this.myProject = file.getProject();
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Collection<JpdlNode> getNodes() {
        Collection<JpdlNode> collection = this.getNodes(true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/graph/JpdlDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<JpdlNode> getNodes(boolean refresh) {
        if (refresh) {
            this.refreshDataModel();
        }
        Collection<JpdlNode> collection = this.myNodes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/graph/JpdlDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<JpdlEdge> getEdges() {
        Collection<JpdlEdge> collection = this.myEdges;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/graph/JpdlDataModel", "getEdges"));
        }
        return collection;
    }

    @NotNull
    public JpdlNode getSourceNode(JpdlEdge jpdlBasicEdge) {
        JpdlNode jpdlNode = jpdlBasicEdge.getSource();
        if (jpdlNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/graph/JpdlDataModel", "getSourceNode"));
        }
        return jpdlNode;
    }

    @NotNull
    public JpdlNode getTargetNode(JpdlEdge jpdlBasicEdge) {
        JpdlNode jpdlNode = jpdlBasicEdge.getTarget();
        if (jpdlNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/graph/JpdlDataModel", "getTargetNode"));
        }
        return jpdlNode;
    }

    @NotNull
    public String getNodeName(JpdlNode jpdlBasicNode) {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/graph/JpdlDataModel", "getNodeName"));
        }
        return "";
    }

    @NotNull
    public String getEdgeName(JpdlEdge jpdlBasicEdge) {
        String string = jpdlBasicEdge.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/graph/JpdlDataModel", "getEdgeName"));
        }
        return string;
    }

    public JpdlEdge createEdge(final @NotNull JpdlNode from, final @NotNull JpdlNode to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/jboss/jpdl/graph/JpdlDataModel", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/jboss/jpdl/graph/JpdlDataModel", "createEdge"));
        }
        final String toName = to.getName();
        final Object element = from.getIdentifyingElement();
        if (element instanceof TransitionOwner) {
            WriteCommandAction<JpdlEdge> action = new WriteCommandAction<JpdlEdge>(this.myProject, new PsiFile[0]){

                protected void run(@NotNull Result<JpdlEdge> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jboss/jpdl/graph/JpdlDataModel$1", "run"));
                    }
                    Transition transition = ((TransitionOwner)element).addTransition();
                    transition.getTo().setStringValue(toName);
                    result.setResult((Object)new JpdlBasicEdge(from, to, (Transition)transition.createStableCopy(), false));
                }
            };
            return (JpdlEdge)action.execute().getResultObject();
        }
        return null;
    }

    public void dispose() {
    }

    private void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    private void clearAll() {
        this.myNodes.clear();
        this.myEdges.clear();
    }

    public void updateDataModel() {
        ProcessDefinition processDefinition = this.getProcessDefinition();
        if (processDefinition == null) {
            return;
        }
        HashMap<String, List<JpdlNode>> allNodes = new HashMap<String, List<JpdlNode>>();
        this.addActivityNodes(processDefinition.getStarts(), new Function<Start, StartNode>(){

            public StartNode fun(Start start) {
                return new StartNode(start);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getStates(), new Function<State, StateNode>(){

            public StateNode fun(State state) {
                return new StateNode(state);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getDecisions(), new Function<Decision, DecisionNode>(){

            public DecisionNode fun(Decision decision) {
                return new DecisionNode(decision);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getTasks(), new Function<Task, TaskNode>(){

            public TaskNode fun(Task task) {
                return new TaskNode(task);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getForks(), new Function<Fork, ForkNode>(){

            public ForkNode fun(Fork fork) {
                return new ForkNode(fork);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getJoins(), new Function<Join, JoinNode>(){

            public JoinNode fun(Join join) {
                return new JoinNode(join);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getEnds(), new Function<End, EndActivityNode.EndNode>(){

            public EndActivityNode.EndNode fun(End end) {
                return new EndActivityNode.EndNode(end);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getEndCancels(), new Function<EndCancel, EndActivityNode.EndCancelNode>(){

            public EndActivityNode.EndCancelNode fun(EndCancel end) {
                return new EndActivityNode.EndCancelNode(end);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getEndErrors(), new Function<EndError, EndActivityNode.EndErrorNode>(){

            public EndActivityNode.EndErrorNode fun(EndError endError) {
                return new EndActivityNode.EndErrorNode(endError);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getSubProcesses(), new Function<SubProcess, SubProcessNode>(){

            public SubProcessNode fun(SubProcess subProcess) {
                return new SubProcessNode(subProcess);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getJavas(), new Function<JavaActivity, JavaNode>(){

            public JavaNode fun(JavaActivity javaActivity) {
                return new JavaNode(javaActivity);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getCustoms(), new Function<Custom, CustomNode>(){

            public CustomNode fun(Custom custom) {
                return new CustomNode(custom);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getSqls(), new Function<Sql, SqlNode>(){

            public SqlNode fun(Sql sql) {
                return new SqlNode(sql);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getHqls(), new Function<Hql, HqlNode>(){

            public HqlNode fun(Hql hql) {
                return new HqlNode(hql);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getRules(), new Function<Rules, RulesNode>(){

            public RulesNode fun(Rules rules) {
                return new RulesNode(rules);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getRulesDecisions(), new Function<RulesDecision, RulesDecisionNode>(){

            public RulesDecisionNode fun(RulesDecision rulesDecision) {
                return new RulesDecisionNode(rulesDecision);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getScripts(), new Function<Script, ScriptNode>(){

            public ScriptNode fun(Script script) {
                return new ScriptNode(script);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getMails(), new Function<Mail, MailNode>(){

            public MailNode fun(Mail mail) {
                return new MailNode(mail);
            }
        }, allNodes);
        this.addActivityNodes(processDefinition.getGroups(), new Function<Group, GroupNode>(){

            public GroupNode fun(Group group) {
                return new GroupNode(group);
            }
        }, allNodes);
        for (List sourceNodes : allNodes.values()) {
            for (JpdlNode sourceNode : sourceNodes) {
                Object identifyingElement = sourceNode.getIdentifyingElement();
                if (!(identifyingElement instanceof TransitionOwner)) continue;
                List<Transition> transitions = ((TransitionOwner)identifyingElement).getTransitions();
                this.addTransitions(sourceNode, transitions, allNodes);
            }
        }
    }

    private void addTransitions(JpdlNode sourceNode, List<Transition> transitions, Map<String, List<JpdlNode>> allNodes) {
        for (Transition transition : transitions) {
            List<JpdlNode> targetNodes;
            String targetNodeName = transition.getTo().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)targetNodeName) || (targetNodes = allNodes.get(targetNodeName)) == null) continue;
            for (JpdlNode targetNode : targetNodes) {
                this.addTransition(new JpdlBasicEdge(sourceNode, targetNode, (Transition)transition.createStableCopy(), targetNodes.size() > 1));
            }
        }
    }

    private void addNode(JpdlNode node) {
        this.myNodes.add(node);
    }

    private void addTransition(JpdlEdge edge) {
        this.myEdges.add(edge);
    }

    private <jpdlNode extends JpdlNode, jpdlActivity extends JpdlNamedActivity> void addActivityNodes(List<jpdlActivity> activities, Function<jpdlActivity, jpdlNode> function, Map<String, List<JpdlNode>> nodes) {
        for (JpdlNamedActivity activity : activities) {
            if (!DomUtil.hasXml((DomElement)activity)) continue;
            String name = activity.getName().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                name = UNDEFINED_NAME;
            }
            if (!nodes.containsKey(name)) {
                nodes.put(name, new ArrayList());
            }
            JpdlNode node = (JpdlNode)function.fun((Object)activity.createStableCopy());
            nodes.get(name).add(node);
            this.addNode(node);
        }
    }

    @Nullable
    public ProcessDefinition getProcessDefinition() {
        JpdlModel model = this.getModel();
        if (model == null || model.getRoots().size() != 1) {
            return null;
        }
        return (ProcessDefinition)((DomFileElement)model.getRoots().get(0)).getRootElement();
    }

    public JpdlModel getModel() {
        return JpdlDomModelManager.getInstance(this.myProject).getJpdlModel(this.myFile);
    }
}

