/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.el;

import com.intellij.jboss.jpdl.el.JpdlELVariablesCollectorUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.ElContextProviderEx;
import com.intellij.psi.impl.source.jsp.el.impl.CustomJsfContextBeansProvider;
import com.intellij.psi.jsp.JspImplicitVariable;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;

public class JpdlElContextProvider
extends ElContextProviderEx {
    private final PsiElement myHost;

    public JpdlElContextProvider(PsiElement host) {
        this.myHost = host;
    }

    @Nullable
    public Iterator<? extends PsiVariable> getTopLevelElVariables(@Nullable String nameHint) {
        ArrayList<JspImplicitVariable> vars = new ArrayList<JspImplicitVariable>();
        vars.addAll(JpdlELVariablesCollectorUtil.collectPredefinedVariables(this.myHost.getContainingFile()));
        for (CustomJsfContextBeansProvider provider : (CustomJsfContextBeansProvider[])Extensions.getExtensions((ExtensionPointName)CustomJsfContextBeansProvider.EP_NAME)) {
            provider.addVars(vars, this.myHost.getContainingFile());
        }
        return vars.iterator();
    }

    public boolean acceptsGetMethodForLastReference(PsiMethod getter) {
        return true;
    }

    public boolean acceptsSetMethodForLastReference(PsiMethod setter) {
        return false;
    }

    public boolean acceptsNonPropertyMethodForLastReference(PsiMethod method) {
        return !JpdlElContextProvider.isObjectClassMethod(method);
    }

    private static boolean isObjectClassMethod(PsiMethod method) {
        return "java.lang.Object".equals(method.getContainingClass().getQualifiedName());
    }
}

