/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.model.xml.bpmn20;

import com.intellij.jboss.jbpm.model.xml.bpmn20.TDataInput;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TInputOutputSpecification;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TInputSet;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalAndWhileExecutingInputRefConvertor
extends ResolvingConverter<TDataInput> {
    @NotNull
    public Collection<TDataInput> getVariants(ConvertContext context) {
        List<TDataInput> variantsImpl = this.getVariantsImpl(context);
        List<Object> list = variantsImpl == null ? Collections.emptyList() : variantsImpl;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/xml/bpmn20/OptionalAndWhileExecutingInputRefConvertor", "getVariants"));
        }
        return list;
    }

    private List<TDataInput> getVariantsImpl(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        DomElement inputSet = element.getParent();
        if (inputSet == null || !TInputSet.class.equals((Object)inputSet.getDomElementType())) {
            return null;
        }
        DomElement ioSpecDomElement = inputSet.getParent();
        if (ioSpecDomElement == null || !TInputOutputSpecification.class.equals((Object)ioSpecDomElement.getDomElementType())) {
            return null;
        }
        ArrayList<TDataInput> result = new ArrayList<TDataInput>();
        List<GenericDomValue<TDataInput>> inputRefses = ((TInputSet)inputSet).getDataInputRefses();
        for (GenericDomValue<TDataInput> refse : inputRefses) {
            TDataInput value;
            if (!refse.isValid() || (value = (TDataInput)refse.getValue()) == null || !value.isValid()) continue;
            result.add(value);
        }
        return result;
    }

    public TDataInput fromString(@Nullable @NonNls String s, ConvertContext context) {
        List<TDataInput> variantsImpl = this.getVariantsImpl(context);
        if (variantsImpl == null) {
            return null;
        }
        for (TDataInput input : variantsImpl) {
            if (!input.getId().isValid() || !Comparing.equal((String)((String)input.getId().getValue()), (String)s)) continue;
            return input;
        }
        return null;
    }

    public String toString(@Nullable TDataInput input, ConvertContext context) {
        return input == null ? null : input.getId().getStringValue();
    }
}

