/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.model.xml.bpmn20;

import com.intellij.jboss.jbpm.model.xml.bpmn20.TDataInput;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TInputOutputSpecification;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TInputSet;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TOutputSet;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataInputRefConvertor
extends ResolvingConverter<TDataInput> {
    public TDataInput fromString(@Nullable @NonNls String s, ConvertContext context) {
        List<TDataInput> inputs = DataInputRefConvertor.getInputs(context);
        if (inputs == null) {
            return null;
        }
        for (TDataInput input : inputs) {
            if (!input.getId().isValid() || !Comparing.equal((String)((String)input.getId().getValue()), (String)s)) continue;
            return input;
        }
        return null;
    }

    public static List<TDataInput> getInputs(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        DomElement inputSet = element.getParent();
        if (inputSet == null || !TOutputSet.class.equals((Object)inputSet.getDomElementType()) && !TInputSet.class.equals((Object)inputSet.getDomElementType())) {
            return null;
        }
        DomElement ioSpecDomElement = inputSet.getParent();
        if (ioSpecDomElement == null || !TInputOutputSpecification.class.equals((Object)ioSpecDomElement.getDomElementType())) {
            return null;
        }
        return ((TInputOutputSpecification)ioSpecDomElement).getDataInputs();
    }

    public String toString(@Nullable TDataInput input, ConvertContext context) {
        if (input == null) {
            return null;
        }
        return input.getId().getStringValue();
    }

    @NotNull
    public Collection<TDataInput> getVariants(ConvertContext context) {
        List<TDataInput> inputs = DataInputRefConvertor.getInputs(context);
        List<Object> list = inputs == null ? Collections.emptyList() : inputs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/xml/bpmn20/DataInputRefConvertor", "getVariants"));
        }
        return list;
    }
}

