/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.model.render;

import com.intellij.jboss.jbpm.BpmnUtils;
import com.intellij.jboss.jbpm.annotation.AnnotationCoordinator;
import com.intellij.jboss.jbpm.chart.model.BpmnChartNode;
import com.intellij.jboss.jbpm.model.render.annotation.DefinitionKind;
import com.intellij.jboss.jbpm.model.render.annotation.EventKind;
import com.intellij.jboss.jbpm.model.xml.bpmn20.EventDefinitionExplicitOwner;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TEvent;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TEventDefinition;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TFlowElement;
import com.intellij.jboss.jbpm.providers.DefaultImageProvider;
import com.intellij.jboss.jbpm.render.pictures.RenderImage;
import com.intellij.openapi.util.IconLoader;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class EventImageProvider
extends DefaultImageProvider<TFlowElement, BpmnChartNode> {
    @NotNull
    private final AnnotationCoordinator<EventKind> eventAnnotationCoordinator = new AnnotationCoordinator(EventKind.class);
    @NotNull
    private final AnnotationCoordinator<DefinitionKind> definitionAnnotationCoordinator = new AnnotationCoordinator(DefinitionKind.class);
    @NotNull
    private static final String noDefinitionKind = "Empty";
    @NotNull
    private static final String multiDefinitionKind = "Multi";
    @NotNull
    private static final String noEventKind = "Start";

    @NotNull
    public Icon getImage(BpmnChartNode node, RenderImage renderImage) {
        Icon icon;
        TEvent event = (TEvent)node.getIdentifyingElement();
        EventKind eventKindAnnotation = (EventKind)this.eventAnnotationCoordinator.getAnnotation(event.getClass());
        String eventKind = eventKindAnnotation == null ? noEventKind : eventKindAnnotation.value();
        String definitionKind = this.getDefinitionName((EventDefinitionExplicitOwner)event);
        try {
            icon = IconLoader.getIcon((String)("JbpmIcons.Bpmn.Events." + eventKind + "_48_" + definitionKind));
        }
        catch (Throwable exc) {
            Icon icon2 = IconLoader.getIcon((String)("JbpmIcons.Bpmn.Events." + eventKind + "_48_" + noDefinitionKind));
            if (icon2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/render/EventImageProvider", "getImage"));
            }
            return icon2;
        }
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/model/render/EventImageProvider", "getImage"));
        }
        return icon;
    }

    private String getDefinitionName(EventDefinitionExplicitOwner eventDefinitionOwner) {
        List<TEventDefinition> eventDefinitions = BpmnUtils.getEventDefinitions(eventDefinitionOwner);
        if (eventDefinitions == null || eventDefinitions.size() == 0) {
            return noDefinitionKind;
        }
        if (eventDefinitions.size() > 1) {
            return multiDefinitionKind;
        }
        TEventDefinition eventDefinition = eventDefinitions.get(0);
        DefinitionKind definitionKind = (DefinitionKind)this.definitionAnnotationCoordinator.getAnnotation(eventDefinition.getClass());
        return definitionKind == null ? noDefinitionKind : definitionKind.value();
    }
}

