/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.model.impl;

import com.intellij.jboss.jbpm.model.BpmnDomModel;
import com.intellij.jboss.jbpm.model.BpmnDomModelManager;
import com.intellij.jboss.jbpm.model.impl.BpmnDomModelFactory;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TDefinitions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmnDomModelManagerImpl
extends BpmnDomModelManager {
    private final BpmnDomModelFactory myDomModelFactory;
    private final DomManager myDomManager;

    public BpmnDomModelManagerImpl(Project project, DomManager domManager) {
        this.myDomManager = domManager;
        this.myDomModelFactory = new BpmnDomModelFactory(project);
    }

    @Override
    public boolean isBpmnDomModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jboss/jbpm/model/impl/BpmnDomModelManagerImpl", "isBpmnDomModel"));
        }
        return this.myDomManager.getFileElement(file, TDefinitions.class) != null;
    }

    @Override
    @Nullable
    public BpmnDomModel getModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jboss/jbpm/model/impl/BpmnDomModelManagerImpl", "getModel"));
        }
        return this.myDomModelFactory.getModelByConfigFile(file);
    }

    @Override
    public List<BpmnDomModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jboss/jbpm/model/impl/BpmnDomModelManagerImpl", "getAllModels"));
        }
        return this.myDomModelFactory.getAllModels((UserDataHolder)module);
    }
}

