/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.model.impl;

import com.intellij.jboss.jbpm.model.BpmnDomModel;
import com.intellij.jboss.jbpm.model.impl.BpmnDomModelImpl;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TDefinitions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.model.impl.DomModelFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmnDomModelFactory
extends DomModelFactory<TDefinitions, BpmnDomModel, PsiElement> {
    BpmnDomModelFactory(Project project) {
        super(TDefinitions.class, project, "definitions");
    }

    @Nullable
    protected List<BpmnDomModel> computeAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jboss/jbpm/model/impl/BpmnDomModelFactory", "computeAllModels"));
        }
        HashSet configFiles = new HashSet();
        configFiles.addAll(DomService.getInstance().getDomFileCandidates(TDefinitions.class, module.getProject(), module.getModuleContentScope()));
        configFiles.addAll(DomService.getInstance().getDomFileCandidates(TDefinitions.class, module.getProject(), GlobalSearchScope.moduleWithLibrariesScope((Module)module)));
        ArrayList<BpmnDomModel> models = new ArrayList<BpmnDomModel>(configFiles.size());
        for (VirtualFile BpmnDomFile : configFiles) {
            PsiFile file = PsiManager.getInstance((Project)module.getProject()).findFile(BpmnDomFile);
            if (!(file instanceof XmlFile)) continue;
            BpmnDomModel bpmnDomModel = this.computeModel((XmlFile)file, module);
            ContainerUtil.addIfNotNull(models, (Object)bpmnDomModel);
        }
        return models;
    }

    @Nullable
    public BpmnDomModel getModelByConfigFile(@Nullable XmlFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        return this.createSingleModel(psiFile);
    }

    @Nullable
    protected BpmnDomModel computeModel(@NotNull XmlFile psiFile, @Nullable Module module) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/jboss/jbpm/model/impl/BpmnDomModelFactory", "computeModel"));
        }
        return this.createSingleModel(psiFile);
    }

    @Nullable
    private BpmnDomModel createSingleModel(XmlFile psiFile) {
        DomFileElement flowDomFileElement = this.getDomRoot(psiFile);
        if (flowDomFileElement == null) {
            return null;
        }
        return new BpmnDomModelImpl((DomFileElement<TDefinitions>)flowDomFileElement, Collections.singleton(psiFile));
    }

    protected BpmnDomModel createCombinedModel(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<TDefinitions> mergedModel, BpmnDomModel firstModel, Module module) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFiles", "com/intellij/jboss/jbpm/model/impl/BpmnDomModelFactory", "createCombinedModel"));
        }
        if (mergedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedModel", "com/intellij/jboss/jbpm/model/impl/BpmnDomModelFactory", "createCombinedModel"));
        }
        throw new UnsupportedOperationException();
    }
}

