/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.diagram.beans.wrappers;

import com.intellij.jboss.jbpm.model.BpmnDomModel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BpmnElementWrapper<T>
implements UserDataHolder {
    private final UserDataHolderBase userDataHolderBase;
    protected static final String DELIMITER = ";";
    protected static final String VALUE_DELIMITER = "=";
    protected T myElement;

    protected BpmnElementWrapper(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnElementWrapper", "<init>"));
        }
        this.userDataHolderBase = new UserDataHolderBase();
        this.myElement = element;
    }

    public T getElement() {
        return this.myElement;
    }

    @NotNull
    public abstract String getName();

    @Nullable
    public abstract String getFqn();

    @NotNull
    public abstract List<BpmnDomModel> getBpmnModels();

    @Nullable
    public Icon getIcon() {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnElementWrapper", "getUserData"));
        }
        return (T)this.userDataHolderBase.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnElementWrapper", "putUserData"));
        }
        this.userDataHolderBase.putUserData(key, value);
    }

    protected static Map<String, String> split(String fqn) {
        List strings = StringUtil.split((String)fqn, (String)DELIMITER);
        HashMap map = new HashMap();
        for (String string : strings) {
            Pair<String, String> pair = BpmnElementWrapper.getPair(string);
            if (pair == null) continue;
            map.put(pair.first, pair.second);
        }
        return map;
    }

    @Nullable
    private static Pair<String, String> getPair(String str) {
        int i = str.indexOf(VALUE_DELIMITER);
        if (i > 0 && i < str.length() - 1) {
            String key = str.substring(0, i).trim();
            String value = str.substring(i + 1).trim();
            if (!StringUtil.isEmptyOrSpaces((String)key) && !StringUtil.isEmptyOrSpaces((String)value)) {
                return Pair.create((Object)key, (Object)value);
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BpmnElementWrapper wrapper = (BpmnElementWrapper)o;
        if (!this.isValid() || !wrapper.isValid()) {
            return false;
        }
        return this.myElement.equals(wrapper.myElement);
    }

    public int hashCode() {
        return this.isValid() ? this.myElement.hashCode() : 0;
    }
}

