/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.diagram.beans.wrappers;

import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnElementWrapper;
import com.intellij.jboss.jbpm.model.BpmnDomModel;
import com.intellij.jboss.jbpm.model.BpmnDomModelManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmnDefinitionsWrapper
extends BpmnElementWrapper<XmlFile> {
    private static final String PATH = "flowPath";

    public BpmnDefinitionsWrapper(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnDefinitionsWrapper", "<init>"));
        }
        super(file);
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((XmlFile)this.myElement).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnDefinitionsWrapper", "getName"));
        }
        return string;
    }

    @Override
    public String getFqn() {
        VirtualFile virtualFile = ((XmlFile)this.myElement).getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return "flowPath=" + virtualFile.getPath();
    }

    @Override
    @NotNull
    public List<BpmnDomModel> getBpmnModels() {
        if (!((XmlFile)this.myElement).isValid()) {
            List<BpmnDomModel> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnDefinitionsWrapper", "getBpmnModels"));
            }
            return list;
        }
        BpmnDomModel model = BpmnDomModelManager.getInstance(((XmlFile)this.myElement).getProject()).getModel((XmlFile)this.myElement);
        assert (model != null) : (XmlFile)this.myElement;
        List<BpmnDomModel> list = Collections.singletonList(model);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnDefinitionsWrapper", "getBpmnModels"));
        }
        return list;
    }

    @Nullable
    public static BpmnElementWrapper resolveElementByFQN(String fqn, Project project) {
        String path = BpmnDefinitionsWrapper.split(fqn).get(PATH);
        XmlFile file = BpmnDefinitionsWrapper.findFile(project, path);
        if (file == null) {
            return null;
        }
        return new BpmnDefinitionsWrapper(file);
    }

    @Nullable
    private static XmlFile findFile(@NotNull Project project, @Nullable String path) {
        PsiFile psiFile;
        VirtualFile relativeFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jboss/jbpm/diagram/beans/wrappers/BpmnDefinitionsWrapper", "findFile"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)path) && (relativeFile = VfsUtil.findRelativeFile((String)path, null)) != null && (psiFile = PsiManager.getInstance((Project)project).findFile(relativeFile)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return null;
    }
}

