/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.chart;

import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.EmptyDiagramVisibilityManager;
import com.intellij.jboss.jbpm.chart.BpmnChartElementManager;
import com.intellij.jboss.jbpm.chart.BpmnChartLayoutCoordinator;
import com.intellij.jboss.jbpm.chart.BpmnChartVfsResolver;
import com.intellij.jboss.jbpm.chart.dnd.BpmnChartDnDSupport;
import com.intellij.jboss.jbpm.chart.model.BpmnChartDataModel;
import com.intellij.jboss.jbpm.chart.model.BpmnChartSource;
import com.intellij.jboss.jbpm.diagram.managers.BpmnDiagramColorManager;
import com.intellij.jboss.jbpm.diagram.managers.BpmnNodeContentManager;
import com.intellij.jboss.jbpm.dnd.ChartDnDSupport;
import com.intellij.jboss.jbpm.layout.ChartLayoutCoordinator;
import com.intellij.jboss.jbpm.model.ChartDataModel;
import com.intellij.jboss.jbpm.model.ChartSource;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TFlowElement;
import com.intellij.jboss.jbpm.settings.ChartProvider;
import com.intellij.jboss.jbpm.ui.ChartBuilder;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmnChartProvider
extends ChartProvider<TFlowElement> {
    @NonNls
    public static final String ID = "BPMN_2_0";
    private final DiagramVisibilityManager visibilityManager = new EmptyDiagramVisibilityManager();
    private final DiagramNodeContentManager nodeContentManager = new BpmnNodeContentManager();
    private final DiagramElementManager<TFlowElement> chartElementManager = new BpmnChartElementManager();
    private final DiagramVfsResolver<TFlowElement> chartVfsResolver = new BpmnChartVfsResolver();
    private final DiagramColorManager diagramColorManager = new BpmnDiagramColorManager();

    public String getChartId() {
        return ID;
    }

    public String getChartName() {
        return "Bpmn 2.0";
    }

    public DiagramVisibilityManager createVisibilityManager() {
        return this.visibilityManager;
    }

    public BpmnChartDataModel createChartDataModel(@NotNull Project project, @NotNull ChartSource source, DiagramPresentationModel presentationModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jboss/jbpm/chart/BpmnChartProvider", "createChartDataModel"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/jboss/jbpm/chart/BpmnChartProvider", "createChartDataModel"));
        }
        assert (source instanceof BpmnChartSource);
        return new BpmnChartDataModel(project, this, (BpmnChartSource)source, presentationModel);
    }

    public DiagramPresentationModel createPresentationModel(@NotNull Project project, @NotNull Graph2D graph) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jboss/jbpm/chart/BpmnChartProvider", "createPresentationModel"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/jboss/jbpm/chart/BpmnChartProvider", "createPresentationModel"));
        }
        return new DiagramPresentationModelImpl(graph, project, (DiagramProvider)this){

            public void customizeSettings(Graph2DView view, EditMode editMode) {
                super.customizeSettings(view, editMode);
                editMode.allowEdgeCreation(true);
                editMode.allowBendCreation(true);
                editMode.allowResizeNodes(true);
            }

            public EdgeCreationPolicy<DiagramNode> getEdgeCreationPolicy() {
                return new EdgeCreationPolicy<DiagramNode>(){

                    public boolean acceptSource(@NotNull DiagramNode source) {
                        if (source == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/jboss/jbpm/chart/BpmnChartProvider$1$1", "acceptSource"));
                        }
                        return true;
                    }

                    public boolean acceptTarget(@NotNull DiagramNode target) {
                        if (target == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/jboss/jbpm/chart/BpmnChartProvider$1$1", "acceptTarget"));
                        }
                        return true;
                    }
                };
            }
        };
    }

    @Nullable
    public ChartDnDSupport creteDnDSupport(ChartDataModel<TFlowElement> dataModel) {
        assert (dataModel instanceof BpmnChartDataModel);
        return new BpmnChartDnDSupport((BpmnChartDataModel)dataModel, (ChartBuilder<TFlowElement>)dataModel.getBuilder());
    }

    public ChartLayoutCoordinator createLayoutCoordinator(Project project, ChartDataModel model) {
        assert (model instanceof BpmnChartDataModel);
        return new BpmnChartLayoutCoordinator(project, (BpmnChartDataModel)model);
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return ID;
    }

    public DiagramNodeContentManager getNodeContentManager() {
        return this.nodeContentManager;
    }

    public DiagramElementManager<TFlowElement> getElementManager() {
        return this.chartElementManager;
    }

    public DiagramVfsResolver<TFlowElement> getVfsResolver() {
        return this.chartVfsResolver;
    }

    public DiagramColorManager getColorManager() {
        return this.diagramColorManager;
    }
}

