/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.unwraptag;

import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import javax.swing.JComponent;
import javax.swing.JLabel;

class UnwrapTagDialog
extends BaseRefactoringDialog {
    private final JLabel tagNameLabel = new JLabel();
    private final String tagName;

    UnwrapTagDialog(XmlTag tag) {
        super(tag.getProject(), true);
        this.setModal(true);
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle("Unwrap Tag");
        this.tagName = tag.getName();
        this.tagNameLabel.setText("Unwrap Tag " + this.tagName);
        this.init();
    }

    protected JComponent createNorthPanel() {
        return this.tagNameLabel;
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.UnwrapTag";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Override
    protected boolean isValid() {
        return this.scopePanel.isScopeValid();
    }

    @Override
    protected String calculateXSLT() {
        return "<xsl:template match=\"" + this.tagName + "\">\n\t<xsl:apply-templates select=\"@*|node()\" />\n</xsl:template>";
    }

    @Override
    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactoring.unwrapTag");
    }
}

