/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.ui;

import com.intellij.find.FindInProjectSettings;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.context.DirectoryContext;
import com.sixrr.xrp.context.EmptyContext;
import com.sixrr.xrp.context.ModuleContext;
import com.sixrr.xrp.context.ProjectContext;
import com.sixrr.xrp.context.RegexFilteredContext;
import com.sixrr.xrp.context.SingleFileContext;
import com.sixrr.xrp.context.URIFilteredContext;
import com.sixrr.xrp.ui.ScopePanelListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class ScopePanel
extends JPanel {
    private final JRadioButton projectButton;
    private final JRadioButton moduleButton;
    private final JRadioButton directoryButton;
    private final JCheckBox recursiveCheckbox;
    private final JCheckBox filterByURICheckbox;
    private final JCheckBox filterByRegexCheckbox;
    private final JTextField regexFilterField;
    private final ComboBox moduleComboBox;
    private final ComboBox directoryComboBox;
    private final FixedSizeButton selectDirectoryButton;
    private final XmlFile file;
    private final ScopePanelListener parent;
    private final String uri;

    public ScopePanel(XmlFile file, ScopePanelListener parent) {
        this.file = file;
        this.uri = this.calculateDocTypeURI();
        this.parent = parent;
        final Project project = file.getProject();
        this.setLayout(new GridBagLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)"Scope", (boolean)true);
        this.setBorder((Border)border);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 2;
        gbConstraints.weightx = 1.0;
        this.projectButton = new JRadioButton("Whole project", true);
        this.projectButton.setMnemonic('p');
        this.add((Component)this.projectButton, gbConstraints);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        this.moduleButton = new JRadioButton("Module: ", false);
        this.moduleButton.setMnemonic('o');
        this.add((Component)this.moduleButton, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 1;
        gbConstraints.weightx = 1.0;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module[] modules = moduleManager.getModules();
        Object[] names = new String[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            names[i] = modules[i].getName();
        }
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        this.moduleComboBox = new ComboBox(names);
        this.add((Component)this.moduleComboBox, gbConstraints);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 2;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        this.directoryButton = new JRadioButton("Directory: ", false);
        this.directoryButton.setMnemonic('D');
        this.add((Component)this.directoryButton, gbConstraints);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 4;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        JRadioButton currentFileButton = new JRadioButton("Current file only", false);
        currentFileButton.setMnemonic('C');
        this.add((Component)currentFileButton, gbConstraints);
        if (this.uri != null) {
            gbConstraints.gridx = 0;
            gbConstraints.gridy = 5;
            gbConstraints.weightx = 1.0;
            gbConstraints.gridwidth = 2;
            this.filterByURICheckbox = new JCheckBox("Limit to files with DTD: " + this.uri, true);
            this.filterByURICheckbox.setSelected(true);
            this.filterByURICheckbox.setMnemonic('D');
            this.add((Component)this.filterByURICheckbox, gbConstraints);
        } else {
            this.filterByURICheckbox = null;
        }
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 6;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 2;
        this.filterByRegexCheckbox = new JCheckBox("Limit to files with names matching regular expression: ");
        this.filterByRegexCheckbox.setSelected(false);
        this.filterByRegexCheckbox.setMnemonic('r');
        this.add((Component)this.filterByRegexCheckbox, gbConstraints);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 7;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 2;
        gbConstraints.insets = new Insets(0, 16, 0, 0);
        this.regexFilterField = new JTextField();
        this.add((Component)this.regexFilterField, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 2;
        gbConstraints.weightx = 1.0;
        gbConstraints.insets = new Insets(0, 16, 0, 0);
        this.directoryComboBox = new ComboBox(-1);
        Component editorComponent = this.directoryComboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField field = (JTextField)editorComponent;
            field.setColumns(40);
        }
        this.add((Component)this.directoryComboBox, gbConstraints);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 2;
        gbConstraints.insets = new Insets(0, 1, 0, 0);
        this.selectDirectoryButton = new FixedSizeButton((JComponent)this.directoryComboBox);
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)this.selectDirectoryButton, (JComponent)this.directoryComboBox);
        this.selectDirectoryButton.setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)this.selectDirectoryButton, gbConstraints);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 3;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 2;
        gbConstraints.insets = new Insets(0, 16, 0, 0);
        this.recursiveCheckbox = new JCheckBox("Recursively", true);
        this.recursiveCheckbox.setSelected(true);
        this.recursiveCheckbox.setMnemonic('r');
        this.add((Component)this.recursiveCheckbox, gbConstraints);
        ButtonGroup bgScope = new ButtonGroup();
        bgScope.add(currentFileButton);
        bgScope.add(this.directoryButton);
        bgScope.add(this.projectButton);
        bgScope.add(this.moduleButton);
        this.projectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopePanel.this.validateScopeControls();
                ScopePanel.this.validateRefactoring();
            }
        });
        currentFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopePanel.this.validateScopeControls();
                ScopePanel.this.validateRefactoring();
            }
        });
        this.filterByRegexCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopePanel.this.validateScopeControls();
                ScopePanel.this.validateRefactoring();
            }
        });
        this.directoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopePanel.this.validateScopeControls();
                ScopePanel.this.validateRefactoring();
                ScopePanel.this.directoryComboBox.getEditor().getEditorComponent().requestFocusInWindow();
            }
        });
        this.moduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopePanel.this.validateScopeControls();
                ScopePanel.this.validateRefactoring();
                ScopePanel.this.moduleComboBox.requestFocusInWindow();
            }
        });
        this.selectDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
                if (file != null) {
                    ScopePanel.this.directoryComboBox.setSelectedItem((Object)file.getPresentableUrl());
                    ScopePanel.this.validateRefactoring();
                }
            }
        });
        PsiDirectory containingDirectory = file.getContainingDirectory();
        this.setDirectories(FindInProjectSettings.getInstance((Project)project).getRecentDirectories(), containingDirectory == null ? null : containingDirectory.getVirtualFile().getPath());
        Module moduleForFile = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (moduleForFile != null) {
            this.moduleComboBox.setSelectedItem((Object)moduleForFile.getName());
        }
        this.projectButton.setEnabled(true);
        this.moduleButton.setEnabled(true);
        this.directoryButton.setEnabled(true);
        currentFileButton.setEnabled(true);
        this.moduleComboBox.setEnabled(false);
        this.recursiveCheckbox.setEnabled(false);
        this.directoryComboBox.setEnabled(false);
        this.selectDirectoryButton.setEnabled(false);
        this.projectButton.setSelected(true);
        this.recursiveCheckbox.setSelected(true);
        this.filterByRegexCheckbox.setSelected(false);
        this.initCombobox(this.directoryComboBox);
    }

    private String calculateDocTypeURI() {
        XmlDocument document = this.file.getDocument();
        if (document == null) {
            return null;
        }
        XmlProlog prolog = document.getProlog();
        if (prolog == null) {
            return null;
        }
        XmlDoctype doctype = prolog.getDoctype();
        if (doctype == null) {
            return null;
        }
        return doctype.getDtdUri();
    }

    public Context getContext() {
        Project project = this.file.getProject();
        String regex = this.getRegex();
        if (this.projectButton.isSelected()) {
            Context context = new ProjectContext(project);
            if (this.uri != null && this.filterByURICheckbox.isSelected()) {
                context = new URIFilteredContext(context, this.uri);
            }
            if (regex != null && regex.length() != 0) {
                context = new RegexFilteredContext(context, regex);
            }
            return context;
        }
        if (this.moduleButton.isSelected()) {
            String moduleName = (String)this.moduleComboBox.getSelectedItem();
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Module module = moduleManager.findModuleByName(moduleName);
            Context context = new ModuleContext(module);
            if (this.uri != null && this.filterByURICheckbox.isSelected()) {
                context = new URIFilteredContext(context, this.uri);
            }
            if (regex != null && regex.length() != 0) {
                context = new RegexFilteredContext(context, regex);
            }
            return context;
        }
        if (this.directoryButton.isSelected()) {
            boolean recursive = this.recursiveCheckbox.isSelected();
            String directoryName = (String)this.directoryComboBox.getSelectedItem();
            PsiManager manager = this.file.getManager();
            VirtualFileManager fileManager = VirtualFileManager.getInstance();
            VirtualFile virtualDirectory = fileManager.findFileByUrl("file://" + directoryName);
            if (virtualDirectory != null) {
                PsiDirectory directory = manager.findDirectory(virtualDirectory);
                Context context = new DirectoryContext(directory, recursive);
                if (this.uri != null && this.filterByURICheckbox.isSelected()) {
                    context = new URIFilteredContext(context, this.uri);
                }
                if (regex != null && regex.length() != 0) {
                    context = new RegexFilteredContext(context, regex);
                }
                return context;
            }
            return new EmptyContext();
        }
        return new SingleFileContext(this.file);
    }

    private String getRegex() {
        if (!this.filterByRegexCheckbox.isSelected()) {
            return null;
        }
        return this.regexFilterField.getText();
    }

    private void setDirectories(List strings, @Nullable String directoryName) {
        if (!StringUtil.isEmpty((String)directoryName)) {
            if (strings.contains(directoryName)) {
                strings.remove(directoryName);
            }
            this.directoryComboBox.addItem((Object)directoryName);
        }
        for (int i = strings.size() - 1; i >= 0; --i) {
            this.directoryComboBox.addItem(strings.get(i));
        }
        if (this.directoryComboBox.getItemCount() == 0) {
            this.directoryComboBox.addItem((Object)"");
        }
    }

    private void validateScopeControls() {
        boolean directorySelected = this.directoryButton.isSelected();
        if (directorySelected) {
            this.recursiveCheckbox.setEnabled(true);
        } else {
            this.recursiveCheckbox.setEnabled(false);
        }
        this.regexFilterField.setEnabled(this.filterByRegexCheckbox.isSelected());
        this.directoryComboBox.setEnabled(directorySelected);
        this.selectDirectoryButton.setEnabled(directorySelected);
        boolean moduleSelected = this.moduleButton.isSelected();
        this.moduleComboBox.setEnabled(moduleSelected);
    }

    private void validateRefactoring() {
        this.parent.scopeSelectionHasChanged();
    }

    public boolean isScopeValid() {
        if (this.directoryButton.isSelected()) {
            return this.getDirectory() != null && this.getDirectory().length() != 0;
        }
        return true;
    }

    private String getDirectory() {
        return (String)this.directoryComboBox.getSelectedItem();
    }

    private void initCombobox(final ComboBox comboBox) {
        comboBox.setEditable(true);
        comboBox.setMaximumRowCount(8);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopePanel.this.validateRefactoring();
            }
        });
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        editorComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Object item = comboBox.getEditor().getItem();
                if (item != null && !item.equals(comboBox.getSelectedItem())) {
                    int caretPosition = ScopePanel.getCaretPosition((JComboBox)comboBox);
                    comboBox.setSelectedItem(item);
                    ScopePanel.setCaretPosition((JComboBox)comboBox, caretPosition);
                }
                ScopePanel.this.validateRefactoring();
            }
        });
    }

    private static int getCaretPosition(JComboBox comboBox) {
        ComboBoxEditor editor = comboBox.getEditor();
        Component editorComponent = editor.getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField textField = (JTextField)editorComponent;
            return textField.getCaretPosition();
        }
        return 0;
    }

    private static void setCaretPosition(JComboBox comboBox, int position) {
        ComboBoxEditor editor = comboBox.getEditor();
        Component editorComponent = editor.getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField textField = (JTextField)editorComponent;
            textField.setCaretPosition(position);
        }
    }
}

