/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.renametag;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.sixrr.xrp.base.BaseTagRefactoringHandler;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.renametag.RenameTagDialog;
import com.sixrr.xrp.renametag.RenameTagProcessor;

class RenameTagHandler
extends BaseTagRefactoringHandler {
    RenameTagHandler() {
    }

    @Override
    protected String getHelpID() {
        return "refactoring.renameTag";
    }

    @Override
    protected String getRefactoringName() {
        return "Rename Tag";
    }

    @Override
    protected void handleTag(XmlTag tag, Project project) {
        RenameTagDialog dialog = new RenameTagDialog(tag);
        if (!dialog.showAndGet()) {
            return;
        }
        Context context = dialog.getContext();
        boolean previewUsages = dialog.isPreviewUsages();
        String newTagName = dialog.getNewTagName();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project, () -> {
            Runnable action = () -> {
                RenameTagProcessor processor = new RenameTagProcessor(tag, newTagName, context, previewUsages);
                processor.run();
            };
            Application application = ApplicationManager.getApplication();
            application.runWriteAction(action);
        }, "Rename Tag", null);
    }
}

