/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.renameattribute;

import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;

class RenameAttributeDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final JTextField newAttributeField;
    private final XmlAttribute attribute;
    private final XmlTag tag;

    RenameAttributeDialog(XmlAttribute attribute) {
        super(attribute.getProject(), true);
        this.attribute = attribute;
        String attributeName = attribute.getName();
        this.tag = attribute.getParent();
        XmlFile containingFile = (XmlFile)this.tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle("Rename Attribute");
        this.attributeNameLabel.setText("New name for attribute " + attributeName);
        this.newAttributeField = new JTextField("");
        Document document = this.newAttributeField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.RenameAttribute";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.newAttributeField;
    }

    public String getNewAttributeName() {
        String text = this.newAttributeField.getText();
        return text.trim();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        String attributeName = this.attribute.getName();
        JPanel panel = new JPanel(new BorderLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)("Change name of attribute " + attributeName + " in tag " + tagName), (boolean)true);
        panel.add((Component)this.attributeNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder((Border)border);
        this.newAttributeField.setEditable(true);
        box.add(this.newAttributeField);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        String tagName = this.getNewAttributeName();
        boolean tagNameEntered = XMLUtil.tagNameIsValid(tagName);
        boolean scopeIsValid = this.scopePanel.isScopeValid();
        return tagNameEntered && scopeIsValid;
    }

    @Override
    protected String calculateXSLT() {
        String tagName = this.tag.getName();
        String attributeName = this.attribute.getName();
        String newAttributeName = this.getNewAttributeName();
        return " <xsl:template match=\"@" + attributeName + "[parent::" + tagName + "]\">\n\t<xsl:attribute name=\"" + newAttributeName + "\">\n\t\t<xsl:value-of select=\".\" />\n\t</xsl:attribute>\n</xsl:template>";
    }

    @Override
    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactoring.renameAttribute");
    }
}

