/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.deletetag;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.deletetag.DeleteTag;
import com.sixrr.xrp.deletetag.DeleteTagUsageViewDescriptor;
import com.sixrr.xrp.psi.TagSearchVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DeleteTagProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final Context context;

    DeleteTagProcessor(XmlTag tag, Context context, boolean previewUsages) {
        super(tag.getProject(), previewUsages);
        this.tag = tag;
        this.context = context;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/deletetag/DeleteTagProcessor", "createUsageViewDescriptor"));
        }
        DeleteTagUsageViewDescriptor deleteTagUsageViewDescriptor = new DeleteTagUsageViewDescriptor(this.tag, usageInfos);
        if (deleteTagUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/deletetag/DeleteTagProcessor", "createUsageViewDescriptor"));
        }
        return deleteTagUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/deletetag/DeleteTagProcessor", "findUsages"));
        }
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            if (xmlTag.getParentTag() == null) continue;
            usages.add(new DeleteTag(xmlTag));
        }
    }

    protected String getCommandName() {
        return "Delete tag " + this.tag.getName();
    }
}

