/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.deletetag;

import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import javax.swing.JComponent;
import javax.swing.JLabel;

class DeleteTagDialog
extends BaseRefactoringDialog {
    private final JLabel tagNameLabel = new JLabel();
    private final String tagName;

    DeleteTagDialog(XmlTag tag) {
        super(tag.getProject(), true);
        this.setModal(true);
        this.setTitle("Delete Tag");
        XmlFile containingFile = (XmlFile)tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.init();
        this.tagName = tag.getName();
        this.tagNameLabel.setText("Delete Tag " + this.tagName);
    }

    protected JComponent createNorthPanel() {
        return this.tagNameLabel;
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.DeleteTag";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Override
    protected boolean isValid() {
        return this.scopePanel.isScopeValid();
    }

    @Override
    protected String calculateXSLT() {
        return "<xsl:template match = \"" + this.tagName + "/>";
    }

    @Override
    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactoring.deleteTag");
    }
}

