/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.changeattributevalue;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.changeattributevalue.ChangeAttributeValue;
import com.sixrr.xrp.changeattributevalue.ChangeAttributeValueUsageViewDescriptor;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ChangeAttributeValueProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlAttribute attribute;
    private final String newAttributeValue;
    private final Context context;

    ChangeAttributeValueProcessor(XmlAttribute attribute, String newAttributeValue, Context context, boolean previewUsages) {
        super(attribute.getProject(), previewUsages);
        this.attribute = attribute;
        this.newAttributeValue = newAttributeValue;
        this.context = context;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/changeattributevalue/ChangeAttributeValueProcessor", "createUsageViewDescriptor"));
        }
        ChangeAttributeValueUsageViewDescriptor changeAttributeValueUsageViewDescriptor = new ChangeAttributeValueUsageViewDescriptor(this.attribute, usageInfos);
        if (changeAttributeValueUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/changeattributevalue/ChangeAttributeValueProcessor", "createUsageViewDescriptor"));
        }
        return changeAttributeValueUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/changeattributevalue/ChangeAttributeValueProcessor", "findUsages"));
        }
        String attributeName = this.attribute.getName();
        String attributeNamespace = this.attribute.getNamespace();
        String attributeValue = this.attribute.getValue();
        XmlTag tag = this.attribute.getParent();
        String tagName = tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            XmlAttribute foundAttribute = xmlTag.getAttribute(attributeName, attributeNamespace);
            if (foundAttribute == null || !foundAttribute.getValue().equals(attributeValue)) continue;
            usages.add(new ChangeAttributeValue(foundAttribute, this.newAttributeValue));
        }
    }

    protected String getCommandName() {
        return "Change value of attribute " + this.attribute.getName();
    }
}

