/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.changeattributevalue;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.sixrr.xrp.base.BaseAttributeRefactoringHandler;
import com.sixrr.xrp.changeattributevalue.ChangeAttributeValueDialog;
import com.sixrr.xrp.changeattributevalue.ChangeAttributeValueProcessor;
import com.sixrr.xrp.context.Context;

class ChangeAttributeValueHandler
extends BaseAttributeRefactoringHandler {
    ChangeAttributeValueHandler() {
    }

    @Override
    protected String getHelpID() {
        return "refactoring.changeAttributeValue";
    }

    @Override
    protected String getRefactoringName() {
        return "Change Attribute Value";
    }

    @Override
    protected void handleAttribute(XmlAttribute attribute, Project project) {
        ChangeAttributeValueDialog dialog = new ChangeAttributeValueDialog(attribute);
        if (!dialog.showAndGet()) {
            return;
        }
        Context context = dialog.getContext();
        String newAttributeValue = dialog.getNewAttributeValue();
        boolean previewUsages = dialog.isPreviewUsages();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project, () -> {
            Runnable action = () -> {
                ChangeAttributeValueProcessor processor = new ChangeAttributeValueProcessor(attribute, newAttributeValue, context, previewUsages);
                processor.run();
            };
            Application application = ApplicationManager.getApplication();
            application.runWriteAction(action);
        }, "Change Attribute Value", null);
    }
}

