/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.server;

import com.intellij.javaee.oss.geronimo.server.GeronimoLocalModel;
import com.intellij.javaee.oss.server.JavaeeParameters;
import com.intellij.javaee.oss.server.JavaeeStartupPolicy;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.annotations.NonNls;

class GeronimoStartupPolicy
extends JavaeeStartupPolicy<GeronimoLocalModel> {
    @NonNls
    private static final String SCRIPT_NAME = "geronimo";

    GeronimoStartupPolicy() {
    }

    protected void getStartupParameters(JavaeeParameters params, GeronimoLocalModel model, boolean debug) {
        params.add(GeronimoStartupPolicy.getScript(model));
        params.add(new String[]{"run"});
        params.add(new String[]{"--quiet"});
    }

    protected void getShutdownParameters(JavaeeParameters params, GeronimoLocalModel model, boolean debug) {
        params.add(GeronimoStartupPolicy.getScript(model));
        params.add(new String[]{"stop"});
        params.add(new String[]{"--user", model.USERNAME});
        params.add(new String[]{"--password", model.PASSWORD});
        params.add(new String[]{"--port", String.valueOf(model.getServerPort())});
    }

    private static File getScript(GeronimoLocalModel model) {
        String scriptExtension = SystemInfo.isWindows ? ".bat" : ".sh";
        File scriptDir = new File(model.getHome(), "bin");
        File scriptFile = new File(scriptDir, SCRIPT_NAME + scriptExtension);
        return scriptFile.exists() ? scriptFile : new File(scriptDir, SCRIPT_NAME);
    }
}

