/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.agent;

import com.intellij.javaee.oss.admin.ModuleTypeWrapper;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.ParametersMapImpl;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;

public class GeronimoDeploymentModel {
    private static final String NAME_PARAM = "name";
    private static final String MODULE_TYPE_PARAM = "module.type";
    private final String myName;
    private final ModuleTypeWrapper myModuleType;

    public static GeronimoDeploymentModel load(String deploymentName) throws JavaeeProcessUtilException {
        ParametersMap parametersMap = ParametersMapImpl.load((String)deploymentName);
        String moduleTypeParam = (String)parametersMap.get((Object)MODULE_TYPE_PARAM);
        ModuleTypeWrapper moduleType = null;
        for (ModuleTypeWrapper moduleTypeValue : ModuleTypeWrapper.values()) {
            if (!moduleTypeValue.getName().equals(moduleTypeParam)) continue;
            moduleType = moduleTypeValue;
            break;
        }
        return new GeronimoDeploymentModel((String)parametersMap.get((Object)NAME_PARAM), moduleType);
    }

    public GeronimoDeploymentModel(String name, ModuleTypeWrapper moduleType) {
        this.myName = name;
        this.myModuleType = moduleType;
    }

    public String getName() {
        return this.myName;
    }

    public ModuleTypeWrapper getModuleType() {
        return this.myModuleType;
    }

    public String save() throws JavaeeProcessUtilException {
        ParametersMapImpl parametersMap = new ParametersMapImpl();
        parametersMap.put((Object)NAME_PARAM, (Object)this.myName);
        parametersMap.put((Object)MODULE_TYPE_PARAM, (Object)(this.myModuleType == null ? "" : this.myModuleType.getName()));
        return parametersMap.save();
    }
}

