/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo;

import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.oss.geronimo.model.GeronimoAppRoot;
import com.intellij.javaee.oss.geronimo.model.GeronimoCommonRoot;
import com.intellij.javaee.oss.geronimo.model.GeronimoEjbRoot;
import com.intellij.javaee.oss.geronimo.model.GeronimoWebRoot;
import com.intellij.javaee.oss.geronimo.server.GeronimoIntegration;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.Nullable;

public class GeronimoUtil {
    private GeronimoUtil() {
    }

    public static boolean isGeronimo10(GeronimoCommonRoot root) {
        XmlTag tag = DomUtil.getFileElement((DomElement)root).getRootTag();
        return tag != null && tag.getNamespace().endsWith(".0");
    }

    @Nullable
    private static <T extends JavaeeDomModelElement> T getRootElement(Class<T> rootClass, @Nullable JavaeeFacet facet) {
        return (T)GeronimoIntegration.getInstance().getDescriptorsManager().getRootElement(rootClass, facet);
    }

    @Nullable
    public static GeronimoAppRoot getAppRoot(@Nullable JavaeeFacet facet) {
        return GeronimoUtil.getRootElement(GeronimoAppRoot.class, facet);
    }

    @Nullable
    public static GeronimoEjbRoot getEjbRoot(@Nullable JavaeeFacet facet) {
        return GeronimoUtil.getRootElement(GeronimoEjbRoot.class, facet);
    }

    @Nullable
    public static GeronimoWebRoot getWebRoot(@Nullable JavaeeFacet facet) {
        return GeronimoUtil.getRootElement(GeronimoWebRoot.class, facet);
    }

    @Nullable
    public static GeronimoCommonRoot getCommonRoot(DeploymentModel deployment) {
        Project project = deployment.getCommonModel().getProject();
        Artifact artifact = deployment.getArtifact();
        if (artifact != null) {
            for (JavaeeFacet facet : JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(project, artifact, null)) {
                for (ConfigFile config : facet.getDescriptorsContainer().getConfigFiles()) {
                    DomManager manager;
                    DomFileElement element;
                    XmlFile file = config.getXmlFile();
                    if (file == null || (element = (manager = DomManager.getDomManager((Project)facet.getModule().getProject())).getFileElement(file, GeronimoCommonRoot.class)) == null) continue;
                    return (GeronimoCommonRoot)element.getRootElement();
                }
            }
        }
        return null;
    }
}

