/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.library;

import com.intellij.openapi.roots.libraries.DummyLibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.SpringBootApiIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootLibraryPresentationProvider
extends LibraryPresentationProvider<DummyLibraryProperties> {
    private static final LibraryKind KIND = LibraryKind.create((String)"spring-boot");

    public SpringBootLibraryPresentationProvider() {
        super(KIND);
    }

    public DummyLibraryProperties detect(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesRoots", "com/intellij/spring/boot/library/SpringBootLibraryPresentationProvider", "detect"));
        }
        if (LibraryUtil.isClassAvailableInLibrary(classesRoots, (String)"org.springframework.boot.SpringApplication")) {
            return DummyLibraryProperties.INSTANCE;
        }
        return null;
    }

    @Nullable
    public Icon getIcon(@Nullable LibraryProperties properties) {
        return SpringBootApiIcons.SpringBoot;
    }
}

