/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.banner;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.spring.boot.banner.SpringBootBannerPropertyReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;

public class SpringBootBannerReferenceContributor
extends PsiReferenceContributor {
    public static final PsiElementPattern.Capture<PsiPlainTextFile> PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiPlainTextFile.class).inFile((ElementPattern)((PsiFilePattern.Capture)PlatformPatterns.psiFile(PsiPlainTextFile.class).withName("banner.txt")).with((PatternCondition)new PatternCondition<PsiPlainTextFile>("springBootLibrary"){

        public boolean accepts(@NotNull PsiPlainTextFile file, ProcessingContext context) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$1", "accepts"));
            }
            return SpringBootLibraryUtil.hasSpringBootLibrary(file.getProject());
        }
    }));
    static final String PREFIX = "${";
    static final String SUFFIX = "}";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider(PATTERN, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$2", "getReferencesByElement"));
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (module == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$2", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                boolean is13 = SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0);
                SmartList references = new SmartList();
                String text = element.getText();
                int startOffset = 0;
                while ((startOffset = text.indexOf(SpringBootBannerReferenceContributor.PREFIX, startOffset)) != -1) {
                    int endOffset = text.indexOf(SpringBootBannerReferenceContributor.SUFFIX, startOffset + SpringBootBannerReferenceContributor.PREFIX.length());
                    if (endOffset == -1) {
                        startOffset += SpringBootBannerReferenceContributor.PREFIX.length();
                        continue;
                    }
                    TextRange range = TextRange.create((int)(startOffset + SpringBootBannerReferenceContributor.PREFIX.length()), (int)endOffset);
                    SpringBootBannerPropertyReference reference = new SpringBootBannerPropertyReference(element, range, is13);
                    references.add(reference);
                    startOffset = endOffset + SpringBootBannerReferenceContributor.SUFFIX.length();
                }
                PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerReferenceContributor$2", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }
}

