/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.banner;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.boot.banner.AnsiColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootBannerPropertyReference
extends PsiReferenceBase<PsiElement> {
    private final boolean myBoot13;

    SpringBootBannerPropertyReference(PsiElement element, TextRange range, boolean isSpringBoot13) {
        super(element, range);
        this.myBoot13 = isSpringBoot13;
    }

    @Nullable
    public PsiElement resolve() {
        return this.getElement();
    }

    private static boolean resolveAnsiColor(String value, String prefix) {
        if (StringUtil.startsWith((CharSequence)value, (CharSequence)prefix)) {
            String name = StringUtil.substringAfter((String)value, (String)prefix);
            return AnsiColor.isValidName(name);
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }
}

