/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlPlaceholderReference;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLHighlighter;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

public class SpringBootApplicationYamlAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlAnnotator", "annotate"));
        }
        if (!(element instanceof YAMLKeyValue)) {
            return;
        }
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        if (!(file instanceof YAMLFile)) {
            return;
        }
        if (!SpringBootApplicationYamlUtil.isApplicationYamlFile((YAMLFile)file)) {
            return;
        }
        YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
        PsiElement yamlKeyElement = yamlKeyValue.getKey();
        if (yamlKeyElement == null) {
            return;
        }
        SpringBootApplicationYamlAnnotator.annotateKey(yamlKeyValue, yamlKeyElement, holder);
        YAMLValue yamlValue = yamlKeyValue.getValue();
        if (yamlValue instanceof YAMLScalar) {
            SpringBootApplicationYamlAnnotator.annotateValue(yamlValue, holder);
        }
    }

    private static void annotateKey(YAMLKeyValue keyValue, PsiElement yamlKeyElement, AnnotationHolder holder) {
        String keyName = SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(keyValue);
        if ("spring.profiles".equals(keyName)) {
            holder.createInfoAnnotation(yamlKeyElement, null).setTextAttributes(DefaultLanguageHighlighterColors.KEYWORD);
        }
    }

    private static void annotateValue(YAMLValue yamlValue, AnnotationHolder holder) {
        for (PsiReference reference : yamlValue.getReferences()) {
            if (!(reference instanceof SpringBootApplicationYamlPlaceholderReference)) continue;
            int elementOffset = yamlValue.getNode().getStartOffset();
            Annotation annotation = holder.createInfoAnnotation(reference.getRangeInElement().shiftRight(elementOffset), null);
            annotation.setTextAttributes(YAMLHighlighter.SCALAR_KEY);
        }
    }
}

