/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.boot.application.metadata.SpringBootMetadataNotificationPanel;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.options.SpringBootEditorOptions;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootMetadataEditorNotificationsProvider
extends EditorNotifications.Provider<SpringBootMetadataNotificationPanel>
implements Disposable {
    private static final Key<SpringBootMetadataNotificationPanel> KEY = Key.create((String)"SpringBootMetadata");
    private final Project myProject;
    private final ParameterizedCachedValue<Object, PsiFile> myPsiClassOwnerCachedTrigger;
    private final MergingUpdateQueue myUpdateQueue;

    public SpringBootMetadataEditorNotificationsProvider(Project project) {
        this.myProject = project;
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.myPsiClassOwnerCachedTrigger = CachedValuesManager.getManager((Project)project).createParameterizedCachedValue((ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<Object, PsiFile>(){

            @Nullable
            public CachedValueProvider.Result<Object> compute(PsiFile psiFile) {
                if (DumbService.isDumb((Project)SpringBootMetadataEditorNotificationsProvider.this.myProject) || SpringBootMetadataEditorNotificationsProvider.this.isRelevantProject()) {
                    SpringBootMetadataEditorNotificationsProvider.this.updateNotifications(psiFile.getVirtualFile());
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{SpringModificationTrackersManager.getInstance((Project)SpringBootMetadataEditorNotificationsProvider.this.myProject).getOuterModelsModificationTracker()});
                }
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{ProjectRootManager.getInstance((Project)SpringBootMetadataEditorNotificationsProvider.this.myProject)});
            }
        }, false);
        this.myUpdateQueue = new MergingUpdateQueue("SpringBootMetadataEditorNotificationsProvider", 2000, true, null, (Disposable)this);
        this.installListeners(project);
    }

    private boolean isRelevantProject() {
        return SpringCommonUtils.hasSpringFacets((Project)this.myProject) && SpringBootLibraryUtil.hasSpringBootLibrary(this.myProject);
    }

    @NotNull
    public Key<SpringBootMetadataNotificationPanel> getKey() {
        Key<SpringBootMetadataNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public SpringBootMetadataNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider", "createNotificationPanel"));
        }
        if (!SpringBootEditorOptions.getInstance().isShowAdditionalConfigNotification()) {
            return null;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider", "lambda$createNotificationPanel$0"));
                }
                this.updateNotifications(file);
            });
            return null;
        }
        if (!this.isRelevantProject()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile == null || !SpringBootMetadataEditorNotificationsProvider.isAdditionalConfigJSON(psiFile) && !SpringBootMetadataEditorNotificationsProvider.isConfigurationPropertiesAnnotatedClass(psiFile)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        if (module == null) {
            return null;
        }
        if (!SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return null;
        }
        return new SpringBootMetadataNotificationPanel(module, psiFile);
    }

    private void updateNotifications(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider", "updateNotifications"));
        }
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file);
    }

    private static boolean isConfigurationPropertiesAnnotatedClass(PsiFile psiFile) {
        if (!(psiFile instanceof PsiClassOwner)) {
            return false;
        }
        PsiClassOwner psiClassOwner = (PsiClassOwner)psiFile;
        Object[] classes = psiClassOwner.getClasses();
        PsiClass psiClass = (PsiClass)ArrayUtil.getFirstElement((Object[])classes);
        if (psiClass == null) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.boot.context.properties.ConfigurationProperties", (boolean)false);
    }

    private static boolean isAdditionalConfigJSON(PsiFile psiFile) {
        return psiFile instanceof JsonFile && psiFile.getName().equals("additional-spring-configuration-metadata.json");
    }

    private void installListeners(Project project) {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                PsiFile file;
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider$2", "propertyChanged"));
                }
                VirtualFile virtualFile = event.getFile();
                if (event.getPropertyName().equals("name") && virtualFile.getFileType() == JsonFileType.INSTANCE && (file = PsiManager.getInstance((Project)SpringBootMetadataEditorNotificationsProvider.this.myProject).findFile(virtualFile)) instanceof JsonFile) {
                    SpringBootMetadataEditorNotificationsProvider.this.updateNotifications(virtualFile);
                }
            }
        }, (Disposable)project);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider$3", "childMoved"));
                }
                this.handleChange(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider$3", "childReplaced"));
                }
                this.handleChange(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider$3", "childRemoved"));
                }
                this.handleChange(event);
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider$3", "childAdded"));
                }
                this.handleChange(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/boot/application/metadata/SpringBootMetadataEditorNotificationsProvider$3", "childrenChanged"));
                }
                this.handleChange(event);
            }

            private void handleChange(PsiTreeChangeEvent event) {
                final PsiFile file = event.getFile();
                if (file instanceof PsiClassOwner || file instanceof JsonFile) {
                    if (DumbService.isDumb((Project)SpringBootMetadataEditorNotificationsProvider.this.myProject)) {
                        return;
                    }
                    SpringBootMetadataEditorNotificationsProvider.this.myUpdateQueue.queue(new Update("SB metadata notification update"){

                        public void run() {
                            SpringBootMetadataEditorNotificationsProvider.this.myPsiClassOwnerCachedTrigger.getValue((Object)file);
                        }
                    });
                }
            }
        }, (Disposable)this.myProject);
    }

    public void dispose() {
        this.myUpdateQueue.cancelAllUpdates();
    }
}

