/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.NestedConfigurationProperty;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBootConfigurationPropertyReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    private static final CachedValueProvider.Result<String> NULL_PREFIX_RESULT = CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});

    protected SpringBootConfigurationPropertyReferenceSearcher() {
        super(true);
    }

    protected abstract void processModule(MethodReferencesSearch.SearchParameters var1, String var2, Module var3);

    protected abstract boolean processFileSet(MethodReferencesSearch.SearchParameters var1, PsiManager var2, String var3, SpringFileSet var4);

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/spring/boot/application/config/SpringBootConfigurationPropertyReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spring/boot/application/config/SpringBootConfigurationPropertyReferenceSearcher", "processQuery"));
        }
        SearchScope scope = queryParameters.getEffectiveSearchScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return;
        }
        Project project = queryParameters.getProject();
        if (!SpringCommonUtils.hasSpringFacets((Project)project) || !SpringBootLibraryUtil.hasSpringBootLibrary(project)) {
            return;
        }
        PsiMethod psiMethod = queryParameters.getMethod();
        String prefix = SpringBootConfigurationPropertyReferenceSearcher.getPrefixIfRelevantPropertyMethod(psiMethod, true);
        if (prefix == null) {
            return;
        }
        Module currentModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMethod);
        Set<Module> relevantModules = this.getRelevantModules(project, currentModule);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (Module next : relevantModules) {
            if (!SpringBootLibraryUtil.hasSpringBootLibrary(next)) continue;
            this.processModule(queryParameters, prefix, next);
            SpringFacet springFacet = SpringFacet.getInstance((Module)next);
            if (springFacet == null) continue;
            for (SpringFileSet fileSet : SpringFileSetService.getInstance().getAllSets(springFacet)) {
                if (this.processFileSet(queryParameters, psiManager, prefix, fileSet)) continue;
                return;
            }
        }
    }

    @Nullable
    public static String getPrefixIfRelevantPropertyMethod(PsiMethod psiMethod, boolean checkIfSetter) {
        if (!psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static") || psiMethod.hasModifierProperty("abstract")) {
            return null;
        }
        if (checkIfSetter && !PropertyUtil.isSimplePropertySetter((PsiMethod)psiMethod)) {
            return null;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)containingClass, () -> {
            if (containingClass.isInterface() || containingClass.hasModifierProperty("abstract") || !SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)containingClass)) {
                return NULL_PREFIX_RESULT;
            }
            ConfigurationProperties configurationProperties = SpringBootConfigurationPropertyReferenceSearcher.findEnclosingOrUsingConfigurationProperties(containingClass);
            if (configurationProperties == null) {
                return NULL_PREFIX_RESULT;
            }
            String prefix = configurationProperties.getValueOrPrefix();
            if (StringUtil.isEmpty((String)prefix)) {
                return NULL_PREFIX_RESULT;
            }
            return CachedValueProvider.Result.create((Object)prefix, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static ConfigurationProperties findEnclosingOrUsingConfigurationProperties(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/boot/application/config/SpringBootConfigurationPropertyReferenceSearcher", "findEnclosingOrUsingConfigurationProperties"));
        }
        ConfigurationProperties currentClass = (ConfigurationProperties)ConfigurationProperties.CLASS_META.getJamElement((PsiModifierListOwner)psiClass);
        if (currentClass != null) {
            return currentClass;
        }
        if (psiClass.getContainingClass() != null) {
            return (ConfigurationProperties)ConfigurationProperties.CLASS_META.getJamElement((PsiModifierListOwner)psiClass.getContainingClass());
        }
        SearchScope classUseScope = psiClass.getUseScope();
        if (!(classUseScope instanceof GlobalSearchScope)) {
            return null;
        }
        JamService jamService = JamService.getJamService((Project)psiClass.getProject());
        List nestedConfigurationProperties = jamService.getJamFieldElements((JamMemberMeta)NestedConfigurationProperty.FIELD_META, "org.springframework.boot.context.properties.NestedConfigurationProperty", (GlobalSearchScope)classUseScope);
        for (NestedConfigurationProperty property : nestedConfigurationProperties) {
            if (!property.typeMatches(psiClass)) continue;
            return property.getEnclosingConfigurationProperties();
        }
        List beanConfigurationProperties = jamService.getJamMethodElements((JamMemberMeta)ConfigurationProperties.Method.METHOD_META, "org.springframework.boot.context.properties.ConfigurationProperties", (GlobalSearchScope)classUseScope);
        for (ConfigurationProperties.Method configurationProperties : beanConfigurationProperties) {
            if (!configurationProperties.isDefinitionFor(psiClass)) continue;
            return configurationProperties;
        }
        return null;
    }

    protected static boolean searchMetaConfigKeyReferences(@NotNull MethodReferencesSearch.SearchParameters queryParameters, final PsiReference[] references) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/spring/boot/application/config/SpringBootConfigurationPropertyReferenceSearcher", "searchMetaConfigKeyReferences"));
        }
        final PsiMethod psiMethod = queryParameters.getMethod();
        final Ref processorResult = Ref.create((Object)Boolean.TRUE);
        ReadActionProcessor<Processor<PsiReference>> customProcessor = new ReadActionProcessor<Processor<PsiReference>>(){

            public boolean processInReadAction(Processor<PsiReference> processor) {
                for (PsiReference reference : references) {
                    PsiElement navigationElement;
                    PsiElement resolve;
                    if (!(reference instanceof MetaConfigKeyReference) || (resolve = reference.resolve()) == null || !((navigationElement = resolve.getNavigationElement()) instanceof PsiMethod) || !navigationElement.getManager().areElementsEquivalent(navigationElement, (PsiElement)psiMethod) || processor.process((Object)reference)) continue;
                    processorResult.set((Object)Boolean.FALSE);
                    return false;
                }
                return true;
            }
        };
        queryParameters.getOptimizer().searchCustom((Processor)customProcessor);
        return (Boolean)processorResult.get();
    }

    @NotNull
    protected Set<Module> getRelevantModules(Project project, @Nullable Module currentModule) {
        HashSet relevantModules = new HashSet();
        if (currentModule == null) {
            ContainerUtil.addAll((Collection)relevantModules, (Object[])ModuleManager.getInstance((Project)project).getModules());
        } else {
            ModuleUtilCore.getDependencies((Module)currentModule, (Set)relevantModules);
        }
        HashSet hashSet = relevantModules;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/SpringBootConfigurationPropertyReferenceSearcher", "getRelevantModules"));
        }
        return hashSet;
    }
}

