/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.lang.reflect.Modifier;
import net.sf.cglib.asm.;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.ClassGenerator;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Signature;
import org.jetbrains.annotations.NotNull;

public class InstanceofCheckerGenerator {
    private static final InstanceofCheckerGenerator ourInstance;
    private final ConcurrentFactoryMap<Class, Condition<Object>> myCache = new ConcurrentFactoryMap<Class, Condition<Object>>(){

        protected Condition<Object> create(final Class key) {
            if (key.isAnonymousClass() || Modifier.isPrivate(key.getModifiers())) {
                return new Condition<Object>(){

                    public boolean value(Object o) {
                        return key.isInstance(o);
                    }
                };
            }
            return new InstanceofClassGenerator(key).createClass();
        }
    };

    public static InstanceofCheckerGenerator getInstance() {
        return ourInstance;
    }

    @NotNull
    public Condition<Object> getInstanceofChecker(Class<?> someClass) {
        Condition condition = (Condition)this.myCache.get(someClass);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/InstanceofCheckerGenerator", "getInstanceofChecker"));
        }
        return condition;
    }

    private static String toInternalName(Class<?> someClass) {
        return someClass.getName().replace('.', '/');
    }

    static {
        try {
            ClassGenerator.class.getDeclaredMethod("generateClass", .ClassVisitor.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Incorrect cglib version in the classpath, source=" + PathManager.getJarPathForClass(ClassGenerator.class));
        }
        try {
            ourInstance = new InstanceofCheckerGenerator();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static class InstanceofClassGenerator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source("IntellijInstanceof");
        private final Class<?> myCheckedClass;

        public InstanceofClassGenerator(Class<?> checkedClass) {
            super(SOURCE);
            this.myCheckedClass = checkedClass;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.myCheckedClass.getClassLoader();
        }

        public Condition<Object> createClass() {
            return (Condition)super.create(this.myCheckedClass);
        }

        @Override
        protected Object firstInstance(Class type) throws Exception {
            return type.newInstance();
        }

        @Override
        protected Object nextInstance(Object instance) throws Exception {
            return instance;
        }

        public void generateClass(.ClassVisitor classVisitor) throws Exception {
            ClassEmitter cv = new ClassEmitter(classVisitor);
            cv.visit(46, 1, "com/intellij/util/InstanceofChecker$$$$$" + this.myCheckedClass.getName().replace('.', '$'), null, InstanceofCheckerGenerator.toInternalName(Object.class), new String[]{InstanceofCheckerGenerator.toInternalName(Condition.class)});
            cv.visitSource("<generated>", null);
            Signature signature = new Signature("<init>", "()V");
            CodeEmitter cons = cv.begin_method(1, signature, new .Type[0]);
            cons.load_this();
            cons.dup();
            cons.super_invoke_constructor(signature);
            cons.return_value();
            cons.end_method();
            CodeEmitter e = cv.begin_method(1, new Signature("value", "(L" + InstanceofCheckerGenerator.toInternalName(Object.class) + ";)Z"), new .Type[0]);
            e.load_arg(0);
            e.instance_of(.Type.getType(this.myCheckedClass));
            .Label fail = e.make_label();
            e.if_jump(153, fail);
            e.push(true);
            e.return_value();
            e.mark(fail);
            e.push(false);
            e.return_value();
            e.end_method();
            cv.visitEnd();
        }
    }
}

