/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewTreeModelBuilder;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class UsageNode
extends Node
implements Comparable<UsageNode>,
Navigatable {
    private final Usage myUsage;
    private boolean myUsageExcluded;

    public UsageNode(@NotNull Usage usage, @NotNull UsageViewTreeModelBuilder model) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/UsageNode", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/usages/impl/UsageNode", "<init>"));
        }
        super(model);
        this.setUserObject(usage);
        this.myUsage = usage;
    }

    @Override
    public String toString() {
        return this.myUsage.toString();
    }

    @Override
    public String tree2string(int indent, String lineSeparator) {
        StringBuffer result = new StringBuffer();
        StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)indent);
        result.append(this.myUsage);
        return result.toString();
    }

    @Override
    public int compareTo(@NotNull UsageNode usageNode) {
        if (usageNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageNode", "com/intellij/usages/impl/UsageNode", "compareTo"));
        }
        return UsageViewImpl.USAGE_COMPARATOR.compare(this.myUsage, usageNode.getUsage());
    }

    @NotNull
    public Usage getUsage() {
        Usage usage = this.myUsage;
        if (usage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/UsageNode", "getUsage"));
        }
        return usage;
    }

    @Override
    public void navigate(boolean requestFocus) {
        this.myUsage.navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return this.myUsage.isValid() && this.myUsage.canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.myUsage.isValid() && this.myUsage.canNavigate();
    }

    @Override
    protected boolean isDataValid() {
        return this.myUsage.isValid();
    }

    @Override
    protected boolean isDataReadOnly() {
        return this.myUsage.isReadOnly();
    }

    @Override
    protected boolean isDataExcluded() {
        return this.myUsageExcluded;
    }

    @Override
    protected String getText(@NotNull UsageView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/usages/impl/UsageNode", "getText"));
        }
        try {
            return this.myUsage.getPresentation().getPlainText();
        }
        catch (AbstractMethodError e) {
            return Arrays.asList(this.myUsage.getPresentation().getText()).toString();
        }
    }

    void setUsageExcluded(boolean usageExcluded) {
        this.myUsageExcluded = usageExcluded;
    }
}

